//------- library
import controlP5.*;
import processing.serial.*;
import processing.xml.*;

Serial myPort;
PFont myFont;
PFont myFontSmall;

//------------GUI
ControlP5 controlP5;
ListBox l;
String[] areaName = {"kanto","kinki","chukyo","hokkaido","okayama","tottori/shimane","sapporo","hakodate","asahikawa","obihiro","kushiro","kitami","muroran","miyagi","akita","yamagata","iwate","fukushima","aomori","tokyo","kanagawa","gunma","ibaraki","chiba","tochigi","saitama","nagano","niigata","yamanashi","aichi","ishikawa","shizuoka","fukui","toyama","mie","gifu","osaka","kyoto","hyogo","wakayama","nara","shiga","hiroshima","okayama","shimane","tottori","yamaguchi","ehime","kagawa","tokushima","kouchi","fukuoka","kumamoto","nagasaki","kagoshima","miyazaki","oita","saga","okinawa"};
int[] areaNumb = {1,2,3,4,5,6,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62};
int currSelectListNumb = 0;

int myColorBackground = color(0,0,0);

public float numberboxValue = 100;
Numberbox n0;
Numberbox n1;
Numberbox n2;
Numberbox n3;
Numberbox n4;
Numberbox n5;
Numberbox n6;
Numberbox n7;
Numberbox n8;
Numberbox n9;
Numberbox n10;
Numberbox n11;

Radio r;
int irToCh[] = new int[12];
int currSelectRadio;
String[] saveStr = new String[3];

String textValue = "";
Textfield recieveTF;
Textfield setTF;


controlP5.Button saveBtn;
int buttonValue = 0;
String[] chTitleData = new String[13];


ListBox xmlToChListBox;




//---------for saving
String AREAID = String.valueOf(areaNumb[10]);
int[] chToFeedNumb =new int[13];//{0,3,7,6,1,4,5,0,0,0,10,0,0};//[ch]=xmlelement xmlの階層情報とハードウェアチャンネルボタンを一致させる配列
int[] serialToCh = {0,3017,527305,265161,789449,134089,658377,396233,920521,68553,592841,330697,854985};
String FeedURL= "http://tv.so-net.ne.jp/rss/schedulesByCurrentTime.action?group=10&stationAreaId="+AREAID;
final int lf = 10;    // Linefeed in ASCII



void setup() {
  size(600,800);
	myFont = createFont("FFScala", 16);
	myFontSmall = createFont("FFScala", 9);
	
  controlP5 = new ControlP5(this);
  controlP5.addButton("saveSetting",0,400,750,80,19);

	
	l = controlP5.addListBox("myList",20,80,120,650);
	l.setItemHeight(15);
	l.setBarHeight(15);
	l.captionLabel().style().marginTop = 3;
	l.captionLabel().set("Select Area");
	l.captionLabel().style().marginTop = 3;
	for(int i=0;i<areaName.length;i++) {
	  l.addItem(areaName[i], areaNumb[i]);
	}
	l.setColorBackground(color(255,128));
	l.setColorActive(color(0,0,255,128));


  r = controlP5.addRadio("radio",180,60);
  r.deactivateAll();
  r.add("Set 1ch's Data",0);
  r.add("Set 2ch's Data",1);
  r.add("Set 3ch's Data",2);
  r.add("Set 4ch's Data",3);
  r.add("Set 5ch's Data",4);
  r.add("Set 6ch's Data",5);
  r.add("Set 7ch's Data",6);
  r.add("Set 8ch's Data",7);
  r.add("Set 9ch's Data",8);
  r.add("Set 10ch's Data",9);
  r.add("Set 11ch's Data",10);
  r.add("Set 12ch's Data",11);

	

	int margin = 40;
	for(int i=1;i<=12;i++){
	  controlP5.addTextfield("Ch"+ String.valueOf(i)+"XML",180,230+margin*i,50,20);		
	}


	String portName = Serial.list()[0];
  myPort = new Serial(this, portName, 9600);
}


void draw() {
	background(128);
	
	//リモコンのデータを受け取る
	if ( myPort.available() > 0) {  // If data is available,
	  try{
	    String val;
	    val = myPort.readStringUntil(lf);
	    val = trim(val);
	    int iVal =Integer.parseInt(val);
		  textFont(myFont);
		  text("Remocon Data\n"+val, 350, 40);
			serialToCh[currSelectRadio+1] = iVal;
	  }
	  catch(NullPointerException e){
	  }
	}
	
	//リモコンの出力する値とキーを設定する
  textFont(myFontSmall);
	fill(255);
	text("ch1:"+serialToCh[1]+"\n"+ "ch2:"+serialToCh[2]+"\n"+ "ch3:"+serialToCh[3]+"\n"+ "ch4:"+serialToCh[4]+"\n"+ "ch5:"+serialToCh[5]+"\n"+ "ch6:"+serialToCh[6]+"\n"+ "ch7:"+serialToCh[7]+"\n"+
	 "ch8:"+serialToCh[8]+"\n"+ "ch9:"+serialToCh[9]+"\n"+ "ch10:"+serialToCh[10]+"\n"+ "ch11:"+serialToCh[11]+"\n"+ "ch12:"+serialToCh[12]+"\n",280,68);
	
	//チャンネル情報の表示
	for(int i=1;i<=12;i++){
		text(i+"   "+chTitleData[i]+"\n",260,350+i*20);
	}
	
	textFont(myFontSmall);
	text("chToFeedNumb " ,260,620);
	for(int i=0;i<chToFeedNumb.length;i++){
		text(chToFeedNumb[i],15*i+260,640);		
	}
	
	textFont(myFontSmall);
	fill(255);
	text("1.視聴している地域を\n選択してください",20,20);
	text("2.ボックスをクリックし、\nリモコンを発光させて1chから12chまで\n記録してください。",180,20);
	text("3.左側のチャンネル毎のボックスに、\n右側のテキストから対応するチャンネルを探して、\nそのチャンネルの先頭にある数字(1,2,3…)を\n入力しエンターキーを押してください",260,280);
	text("4.save buttonを押し、\nこのプログラムと同じフォルダに出力される\nTakeMeToTheRemoconTwitFolder.pdeを\nremoconTwit.pdeと同じフォルダに\nコピーしてください",400,680);
	
}


//ラジオボタンに何かあれば
void radio(int theID) {
  switch(theID) {
    case(0):
			currSelectRadio = 0;
      break;  
    case(1):
			currSelectRadio = 1;
      break;  
    case(2):
			currSelectRadio = 2;
      break;  
    case(3):
			currSelectRadio = 3;
      break;  
    case(4):
			currSelectRadio = 4;
      break;
    case(5):
			currSelectRadio = 5;
      break;  
    case(6):
			currSelectRadio = 6;
      break;  
    case(7):
			currSelectRadio = 7;
      break;  
    case(8):
			currSelectRadio = 8;
      break;  
    case(9):
			currSelectRadio = 9;
      break;
    case(10):
			currSelectRadio = 10;
      break;  
    case(11):
			currSelectRadio = 11;
      break;  
  }
}


void controlEvent(ControlEvent theEvent) {
  if (theEvent.isGroup()) {
		// println(theEvent.group().value()+" from "+theEvent.group());
		l.captionLabel().set(theEvent.group().stringValue());
		AREAID =  String.valueOf(int(theEvent.group().value()));//stringValue();//3.0
  }
	chTitleData = getTitle("http://tv.so-net.ne.jp/rss/schedulesByCurrentTime.action?group=10&stationAreaId="+AREAID);

}



public void saveSetting(int theValue) {
	
  saveStr[0] = "int[] chToFeedNumbO = {"+chToFeedNumb[0]+","+chToFeedNumb[1]+","+chToFeedNumb[2]+","+chToFeedNumb[3]+","+chToFeedNumb[4]+","+chToFeedNumb[5]+","+chToFeedNumb[6]+","+chToFeedNumb[7]+","+chToFeedNumb[8]+","+chToFeedNumb[9]+","+chToFeedNumb[10]+","+chToFeedNumb[11]+","+chToFeedNumb[12]+"};";
  saveStr[1] = "int[] serialToChO = {"+serialToCh[0]+","+serialToCh[1]+","+serialToCh[2]+","+serialToCh[3]+","+serialToCh[4]+","+serialToCh[5]+","+serialToCh[6]+","+serialToCh[7]+","+serialToCh[8]+","+serialToCh[9]+","+serialToCh[10]+","+serialToCh[11]+","+serialToCh[12]+"};";
  saveStr[2] = "String feedURLO = \"http://tv.so-net.ne.jp/rss/schedulesByCurrentTime.action?group=10&stationAreaId="+AREAID+"\";";
	
	println("a button event from buttonA: "+theValue);
	saveStrings("TakeMeToTheRemoconTwitFolder.pde", saveStr);
}



String[] getTitle(String url){	
  String[] chTitle = new String[13];
	try{
		XMLElement rss = new XMLElement(this, url);
		XMLElement item;
		XMLElement titleElement;

		for(int i=0;i<12;i++){
		  item = rss.getChild(i);
		  titleElement = item.getChild(2);
		  chTitle[i] = titleElement.getContent();
		}
	
		return chTitle;
	}catch(ArrayIndexOutOfBoundsException e){
		return chTitle;
	}
}



public void Ch1XML(String theText) {
	chToFeedNumb[1] = Integer.parseInt(theText);
}

public void Ch2XML(String theText) {
		chToFeedNumb[2] = Integer.parseInt(theText);
}

public void Ch3XML(String theText) {
		chToFeedNumb[3] = Integer.parseInt(theText);
}

public void Ch4XML(String theText) {
		chToFeedNumb[4] = Integer.parseInt(theText);
}

public void Ch5XML(String theText) {
		chToFeedNumb[5] = Integer.parseInt(theText);
}

public void Ch6XML(String theText) {
		chToFeedNumb[6] = Integer.parseInt(theText);
}

public void Ch7XML(String theText) {
		chToFeedNumb[7] = Integer.parseInt(theText);
}

public void Ch8XML(String theText) {
		chToFeedNumb[8] = Integer.parseInt(theText);
}

public void Ch9XML(String theText) {
		chToFeedNumb[9] = Integer.parseInt(theText);
}

public void Ch10XML(String theText) {
		chToFeedNumb[10] = Integer.parseInt(theText);
}

public void Ch11XML(String theText) {
		chToFeedNumb[11] = Integer.parseInt(theText);
}

public void Ch12XML(String theText) {
		chToFeedNumb[12] = Integer.parseInt(theText);
}
