//utility program for remoconTwit
//
//oppey.org


//------- library
import controlP5.*;
import processing.serial.*;
import processing.xml.*;

Serial myPort;
PFont myFont;
PFont myFontSmall;

//------------GUI
ControlP5 controlP5;
ListBox l;
String[] areaName = {"kanto","kinki","chukyo","hokkaido","okayama","tottori/shimane","sapporo","hakodate","asahikawa","obihiro","kushiro","kitami","muroran","miyagi","akita","yamagata","iwate","fukushima","aomori","tokyo","kanagawa","gunma","ibaraki","chiba","tochigi","saitama","nagano","niigata","yamanashi","aichi","ishikawa","shizuoka","fukui","toyama","mie","gifu","osaka","kyoto","hyogo","wakayama","nara","shiga","hiroshima","okayama","shimane","tottori","yamaguchi","ehime","kagawa","tokushima","kouchi","fukuoka","kumamoto","nagasaki","kagoshima","miyazaki","oita","saga","okinawa"};
int[] areaNumb = {1,2,3,4,5,6,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62};
int currSelectListNumb = 0;
final int chMax = 12;

int myColorBackground = color(0,0,0);

public float numberboxValue = 100;
Numberbox n0;
Numberbox n1;
Numberbox n2;
Numberbox n3;
Numberbox n4;
Numberbox n5;
Numberbox n6;
Numberbox n7;
Numberbox n8;
Numberbox n9;
Numberbox n10;
Numberbox n11;

Radio r;
int irToCh[] = new int[12];
int currSelectRadio;
String[] saveStr = new String[3];

String textValue = "";
Textfield recieveTF;
Textfield setTF;


controlP5.Button saveBtn;
int buttonValue = 0;
String[] chTitleData = new String[13];


RadioButton chRadioBtn;


ListBox chXmlList;


RadioButton selectedChXMLRB;
int currSelectedCh;
int currSelectedXml;


controlP5.Button xmlSelectButton;



//---------for saving
String AREAID = String.valueOf(areaNumb[10]);
int[] chToFeedNumb =new int[13];//xmlの階層情報とハードウェアチャンネルボタンを一致させる配列
int[] serialToCh = {0,3017,527305,265161,789449,134089,658377,396233,920521,68553,592841,330697,854985};
String FeedURL= "http://tv.so-net.ne.jp/rss/schedulesByCurrentTime.action?group=10&stationAreaId="+AREAID;
final int lf = 10;// Linefeed in ASCII


//初期化する
void setup() {
  size(1000,700);
	myFont = createFont("FFScala", 16);
	myFontSmall = createFont("FFScala", 9);
	
  controlP5 = new ControlP5(this);
  controlP5.addButton("Save & Quit",0,720,100,80,19);

	
	//地域リスト
	l = controlP5.addListBox("chList",20,80,120,400);
	l.setItemHeight(15);
	l.setBarHeight(15);
	l.captionLabel().style().marginTop = 3;
	l.captionLabel().set("Select Area");
	l.captionLabel().style().marginTop = 3;
	for(int i=0;i<areaName.length;i++) {
	  l.addItem(areaName[i], areaNumb[i]);
	}
	l.setColorBackground(color(255,128));
	l.setColorActive(color(0,0,255,128));


	//発光信号とリモコンの押下ボタンをあわせる
  r = controlP5.addRadio("radio",180,60);
  r.deactivateAll();
  r.add("Set 1ch's Data",0);
  r.add("Set 2ch's Data",1);
  r.add("Set 3ch's Data",2);
  r.add("Set 4ch's Data",3);
  r.add("Set 5ch's Data",4);
  r.add("Set 6ch's Data",5);
  r.add("Set 7ch's Data",6);
  r.add("Set 8ch's Data",7);
  r.add("Set 9ch's Data",8);
  r.add("Set 10ch's Data",9);
  r.add("Set 11ch's Data",10);
  r.add("Set 12ch's Data",11);

	//テレビリモコン型のラジオボタン。xml合わせ用。
	chRadioBtn = controlP5.addRadioButton("chRadioBtn",400,380);
  chRadioBtn.setColorForeground(color(120));
  chRadioBtn.setColorActive(color(255));
  chRadioBtn.setColorLabel(color(255));
  chRadioBtn.setItemsPerRow(3);
  chRadioBtn.setSpacingColumn(25);
  chRadioBtn.setItemWidth(30);
  chRadioBtn.setItemHeight(30);

  addToRadioButton(chRadioBtn,"1ch",1);
  addToRadioButton(chRadioBtn,"2ch",2);
  addToRadioButton(chRadioBtn,"3ch",3);
  addToRadioButton(chRadioBtn,"4ch",4);
  addToRadioButton(chRadioBtn,"5ch",5);
  addToRadioButton(chRadioBtn,"6ch",6);
  addToRadioButton(chRadioBtn,"7ch",7);
  addToRadioButton(chRadioBtn,"8ch",8);
  addToRadioButton(chRadioBtn,"9ch",9);
  addToRadioButton(chRadioBtn,"10ch",10);
  addToRadioButton(chRadioBtn,"11ch",11);
  addToRadioButton(chRadioBtn,"12ch",12);
	
	//ボタン
	for(int i=1;i<=12;i++){
	  xmlSelectButton = controlP5.addButton("     "+String.valueOf(i),0,400,18*i+80,20,15);
		xmlSelectButton.setColorLabel(color(128));
	}

	//地域リスト
	selectedChXMLRB = controlP5.addRadioButton("selectedChXMLRB",400,180);
  selectedChXMLRB.setColorForeground(color(120));
  selectedChXMLRB.setColorActive(color(255));
  selectedChXMLRB.setColorLabel(color(255));
  selectedChXMLRB.setItemsPerRow(3);
  selectedChXMLRB.setSpacingColumn(25);
  selectedChXMLRB.setItemWidth(30);
  selectedChXMLRB.setItemHeight(30);

	String portName = Serial.list()[0];
  myPort = new Serial(this, portName, 9600);
	frameRate(30);
}

int iLastSerialVal = 0;
void draw() {
	//画面をリフレッシュする
	background(128);
	
	//リモコンのデータを受け取る
	if ( myPort.available() > 0){
	  try{
	    String val;
	    val = myPort.readStringUntil(lf);
	    val = trim(val);
			int iVal =Integer.parseInt(val);
			if(iVal==iLastSerialVal){			
			  textFont(myFont);
			  text("Remocon Data\n"+val, 350, 40);
				serialToCh[currSelectRadio+1] = iVal;
			}
			iLastSerialVal = iVal;
	  }
	  catch(NullPointerException e){
	  }
	}
	
	//リモコンの出力する値とキーを設定する
  textFont(myFontSmall);
	fill(255);
	text("ch1:"+serialToCh[1]+"\n"+ "ch2:"+serialToCh[2]+"\n"+ "ch3:"+serialToCh[3]+"\n"+ "ch4:"+serialToCh[4]+"\n"+ "ch5:"+serialToCh[5]+"\n"+ "ch6:"+serialToCh[6]+"\n"+ "ch7:"+serialToCh[7]+"\n"+
	 "ch8:"+serialToCh[8]+"\n"+ "ch9:"+serialToCh[9]+"\n"+ "ch10:"+serialToCh[10]+"\n"+ "ch11:"+serialToCh[11]+"\n"+ "ch12:"+serialToCh[12]+"\n",280,68);
	
	//ネットから取得したチャンネル情報の表示
	for(int i=1;i<=12;i++){
		//もし選択中のボタンと、これから描画するテキストの順番が等しければ
		if(chToFeedNumb[currSelectedCh]==i){
			fill(255);
		}else{
			fill(180);
		}
		text(chTitleData[i]+"\n",430,90+i*18);
	}

	//チャンネルとxml合わせデータの表示 確認用
	textFont(myFontSmall);
	fill(180);
	text("chToFeedNumb " ,400,580);
	//chTofeednumb配列の中身表示
	for(int i=0;i<chToFeedNumb.length;i++){
		text(chToFeedNumb[i],15*i+400,600);		
	}
	
	//コメント表示
	textFont(myFontSmall);
	fill(255);
	text("1.視聴している地域を\n選択してください",20,20);
	text("2.ボックスをクリックし、\nリモコンを発光させて1chから12chまで\n記録してください。",180,20);
	text("4.save&quitを押し、\nこのプログラムと同じフォルダに出力される\nTakeMeToTheRemoconTwitFolder.pdeを\nremoconTwit.pdeと同じフォルダに\nコピーしてください",720,20);
	fill(180);
	text("(3.リモコン型のマスから設定するリモコンのボタンを選び\nリストから対応する放送局をを探して、\n設定と異なる場合は行頭のボタンをクリックして選択ください)",400,20);
	
}

//インターネット上から放送局名を取得する
int getChFromTitle(String title){
	int gotCh=0;
	try{
		String string = title;//"5/6 16:53～19:00 [テレビ朝日(Ch.15)]";
		String regex = "[ch\\.]\\d{1,2}";
		Pattern p = Pattern.compile(regex);
		Matcher m = p.matcher(string);

		if (m.find()){
		  String s = string.substring(m.start(), m.end());

		  String regex2 = "\\d{1,2}";
		  Pattern p2 = Pattern.compile(regex2);
		  Matcher m2 = p2.matcher(s);

		  if(m2.find()){
		    String sChXml = s.substring(m2.start(),m2.end());
		    int chXml = Integer.valueOf(sChXml);
				gotCh = chXml;
		  }

		}
		return gotCh;
	}catch(NullPointerException n){
		return gotCh;
	}

}


//何か変化があったラジオボタンの番号をかえす
void radio(int theID) {
  switch(theID) {
    case(0):
			currSelectRadio = 0;
      break;  
    case(1):
			currSelectRadio = 1;
      break;  
    case(2):
			currSelectRadio = 2;
      break;  
    case(3):
			currSelectRadio = 3;
      break;  
    case(4):
			currSelectRadio = 4;
      break;
    case(5):
			currSelectRadio = 5;
      break;  
    case(6):
			currSelectRadio = 6;
      break;  
    case(7):
			currSelectRadio = 7;
      break;  
    case(8):
			currSelectRadio = 8;
      break;  
    case(9):
			currSelectRadio = 9;
      break;
    case(10):
			currSelectRadio = 10;
      break;  
    case(11):
			currSelectRadio = 11;
      break;  
  }
}

//ラジオボタンにトグルをつける
void addToRadioButton(RadioButton theRadioButton, String theName, int theValue ) {
  Toggle t = theRadioButton.addItem(theName,theValue);
}


//インターフェースイベントを監視
void controlEvent(ControlEvent theEvent) {
	//chListに変化があれば
  if (theEvent.isGroup()&&theEvent.name()=="chList") {
		l.captionLabel().set(theEvent.group().stringValue());
		AREAID =  String.valueOf(int(theEvent.group().value()));
		chTitleData = getTitle("http://tv.so-net.ne.jp/rss/schedulesByCurrentTime.action?group=10&stationAreaId="+AREAID);
		
		//チャンネルとxmlを合わせる。
		for(int i=1;i<12;i++){
			chToFeedNumb[i] =0;
			for(int j=1;j<12;j++){
				//もし番組チャンネル名とxml番号が一致するなら代入する
				if(i==getChFromTitle(chTitleData[j])){
					chToFeedNumb[i] = j;
				}
			}
		}
  }

	//チャンネルラジオボタンに変化があれば
	if(theEvent.isGroup()&&theEvent.name()=="chRadioBtn"){
		currSelectedCh = int(theEvent.group().stringValue());
		currSelectedXml = 0;
	}
	
	//ボタンが押されたら
	for(int i=1;i<=12;i++){
		if(i==int(trim(theEvent.name()))){
			chToFeedNumb[currSelectedCh] = i;
		}
	}
}


//セッティングを記録する
public void saveSetting(int theValue) {
  saveStr[0] = "int[] chToFeedNumbO = {"+chToFeedNumb[0]+","+chToFeedNumb[1]+","+chToFeedNumb[2]+","+chToFeedNumb[3]+","+chToFeedNumb[4]+","+chToFeedNumb[5]+","+chToFeedNumb[6]+","+chToFeedNumb[7]+","+chToFeedNumb[8]+","+chToFeedNumb[9]+","+chToFeedNumb[10]+","+chToFeedNumb[11]+","+chToFeedNumb[12]+"};";
  saveStr[1] = "int[] serialToChO = {"+serialToCh[0]+","+serialToCh[1]+","+serialToCh[2]+","+serialToCh[3]+","+serialToCh[4]+","+serialToCh[5]+","+serialToCh[6]+","+serialToCh[7]+","+serialToCh[8]+","+serialToCh[9]+","+serialToCh[10]+","+serialToCh[11]+","+serialToCh[12]+"};";
  saveStr[2] = "String feedURLO = \"http://tv.so-net.ne.jp/rss/schedulesByCurrentTime.action?group=10&stationAreaId="+AREAID+"\";";
	
	println("Save button pressed "+theValue);
	saveStrings("TakeMeToTheRemoconTwitFolder.pde", saveStr);
	exit();
}



//タイトル情報を返す
String[] getTitle(String url){	
  String[] chTitle = new String[13];
	try{
		XMLElement rss = new XMLElement(this, url);
		XMLElement item;
		XMLElement titleElement;

		for(int i=0;i<12;i++){
		  item = rss.getChild(i);
		  titleElement = item.getChild(2);
		  chTitle[i] = titleElement.getContent();
		}
	
		return chTitle;
	}catch(ArrayIndexOutOfBoundsException e){
		return chTitle;
	}
}
