import processing.core.*; 
import processing.xml.*; 

import controlP5.*; 
import processing.serial.*; 
import processing.xml.*; 

import controlP5.*; 

import java.applet.*; 
import java.awt.Dimension; 
import java.awt.Frame; 
import java.awt.event.MouseEvent; 
import java.awt.event.KeyEvent; 
import java.awt.event.FocusEvent; 
import java.awt.Image; 
import java.io.*; 
import java.net.*; 
import java.text.*; 
import java.util.*; 
import java.util.zip.*; 
import java.util.regex.*; 

public class remoconUtil extends PApplet {

//utility program for remoconTwit
//
//oppey.org


//------- library




Serial myPort;
PFont myFont;
PFont myFontSmall;

//------------GUI
ControlP5 controlP5;
ListBox l;
String[] areaName = {"kanto","kinki","chukyo","hokkaido","okayama","tottori/shimane","sapporo","hakodate","asahikawa","obihiro","kushiro","kitami","muroran","miyagi","akita","yamagata","iwate","fukushima","aomori","tokyo","kanagawa","gunma","ibaraki","chiba","tochigi","saitama","nagano","niigata","yamanashi","aichi","ishikawa","shizuoka","fukui","toyama","mie","gifu","osaka","kyoto","hyogo","wakayama","nara","shiga","hiroshima","okayama","shimane","tottori","yamaguchi","ehime","kagawa","tokushima","kouchi","fukuoka","kumamoto","nagasaki","kagoshima","miyazaki","oita","saga","okinawa"};
int[] areaNumb = {1,2,3,4,5,6,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62};
int currSelectListNumb = 0;
final int chMax = 12;

int myColorBackground = color(0,0,0);

public float numberboxValue = 100;
Numberbox n0;
Numberbox n1;
Numberbox n2;
Numberbox n3;
Numberbox n4;
Numberbox n5;
Numberbox n6;
Numberbox n7;
Numberbox n8;
Numberbox n9;
Numberbox n10;
Numberbox n11;

Radio r;
int irToCh[] = new int[12];
int currSelectRadio;
String[] saveStr = new String[3];

String textValue = "";
Textfield recieveTF;
Textfield setTF;


controlP5.Button saveBtn;
int buttonValue = 0;
String[] chTitleData = new String[13];


RadioButton chRadioBtn;


ListBox chXmlList;


RadioButton selectedChXMLRB;
int currSelectedCh;
int currSelectedXml;


controlP5.Button xmlSelectButton;



//---------for saving
String AREAID = String.valueOf(areaNumb[10]);
int[] chToFeedNumb =new int[13];//xml\u306e\u968e\u5c64\u60c5\u5831\u3068\u30cf\u30fc\u30c9\u30a6\u30a7\u30a2\u30c1\u30e3\u30f3\u30cd\u30eb\u30dc\u30bf\u30f3\u3092\u4e00\u81f4\u3055\u305b\u308b\u914d\u5217
int[] serialToCh = {0,3017,527305,265161,789449,134089,658377,396233,920521,68553,592841,330697,854985};
String FeedURL= "http://tv.so-net.ne.jp/rss/schedulesByCurrentTime.action?group=10&stationAreaId="+AREAID;
final int lf = 10;// Linefeed in ASCII


//\u521d\u671f\u5316\u3059\u308b
public void setup() {
  size(1000,700);
	myFont = createFont("FFScala", 16);
	myFontSmall = createFont("FFScala", 9);
	
  controlP5 = new ControlP5(this);
  controlP5.addButton("Save & Quit",0,720,100,80,19);

	
	//\u5730\u57df\u30ea\u30b9\u30c8
	l = controlP5.addListBox("chList",20,80,120,400);
	l.setItemHeight(15);
	l.setBarHeight(15);
	l.captionLabel().style().marginTop = 3;
	l.captionLabel().set("Select Area");
	l.captionLabel().style().marginTop = 3;
	for(int i=0;i<areaName.length;i++) {
	  l.addItem(areaName[i], areaNumb[i]);
	}
	l.setColorBackground(color(255,128));
	l.setColorActive(color(0,0,255,128));


	//\u767a\u5149\u4fe1\u53f7\u3068\u30ea\u30e2\u30b3\u30f3\u306e\u62bc\u4e0b\u30dc\u30bf\u30f3\u3092\u3042\u308f\u305b\u308b
  r = controlP5.addRadio("radio",180,60);
  r.deactivateAll();
  r.add("Set 1ch's Data",0);
  r.add("Set 2ch's Data",1);
  r.add("Set 3ch's Data",2);
  r.add("Set 4ch's Data",3);
  r.add("Set 5ch's Data",4);
  r.add("Set 6ch's Data",5);
  r.add("Set 7ch's Data",6);
  r.add("Set 8ch's Data",7);
  r.add("Set 9ch's Data",8);
  r.add("Set 10ch's Data",9);
  r.add("Set 11ch's Data",10);
  r.add("Set 12ch's Data",11);

	//\u30c6\u30ec\u30d3\u30ea\u30e2\u30b3\u30f3\u578b\u306e\u30e9\u30b8\u30aa\u30dc\u30bf\u30f3\u3002xml\u5408\u308f\u305b\u7528\u3002
	chRadioBtn = controlP5.addRadioButton("chRadioBtn",400,380);
  chRadioBtn.setColorForeground(color(120));
  chRadioBtn.setColorActive(color(255));
  chRadioBtn.setColorLabel(color(255));
  chRadioBtn.setItemsPerRow(3);
  chRadioBtn.setSpacingColumn(25);
  chRadioBtn.setItemWidth(30);
  chRadioBtn.setItemHeight(30);

  addToRadioButton(chRadioBtn,"1ch",1);
  addToRadioButton(chRadioBtn,"2ch",2);
  addToRadioButton(chRadioBtn,"3ch",3);
  addToRadioButton(chRadioBtn,"4ch",4);
  addToRadioButton(chRadioBtn,"5ch",5);
  addToRadioButton(chRadioBtn,"6ch",6);
  addToRadioButton(chRadioBtn,"7ch",7);
  addToRadioButton(chRadioBtn,"8ch",8);
  addToRadioButton(chRadioBtn,"9ch",9);
  addToRadioButton(chRadioBtn,"10ch",10);
  addToRadioButton(chRadioBtn,"11ch",11);
  addToRadioButton(chRadioBtn,"12ch",12);
	
	//\u30dc\u30bf\u30f3
	for(int i=1;i<=12;i++){
	  xmlSelectButton = controlP5.addButton("     "+String.valueOf(i),0,400,18*i+80,20,15);
		xmlSelectButton.setColorLabel(color(128));
	}

	//\u5730\u57df\u30ea\u30b9\u30c8
	selectedChXMLRB = controlP5.addRadioButton("selectedChXMLRB",400,180);
  selectedChXMLRB.setColorForeground(color(120));
  selectedChXMLRB.setColorActive(color(255));
  selectedChXMLRB.setColorLabel(color(255));
  selectedChXMLRB.setItemsPerRow(3);
  selectedChXMLRB.setSpacingColumn(25);
  selectedChXMLRB.setItemWidth(30);
  selectedChXMLRB.setItemHeight(30);

	String portName = Serial.list()[0];
  myPort = new Serial(this, portName, 9600);
	frameRate(30);
}

int iLastSerialVal = 0;
public void draw() {
	//\u753b\u9762\u3092\u30ea\u30d5\u30ec\u30c3\u30b7\u30e5\u3059\u308b
	background(128);
	
	//\u30ea\u30e2\u30b3\u30f3\u306e\u30c7\u30fc\u30bf\u3092\u53d7\u3051\u53d6\u308b
	if ( myPort.available() > 0){
	  try{
	    String val;
	    val = myPort.readStringUntil(lf);
	    val = trim(val);
			int iVal =Integer.parseInt(val);
			if(iVal==iLastSerialVal){			
			  textFont(myFont);
			  text("Remocon Data\n"+val, 350, 40);
				serialToCh[currSelectRadio+1] = iVal;
			}
			iLastSerialVal = iVal;
	  }
	  catch(NullPointerException e){
	  }
	}
	
	//\u30ea\u30e2\u30b3\u30f3\u306e\u51fa\u529b\u3059\u308b\u5024\u3068\u30ad\u30fc\u3092\u8a2d\u5b9a\u3059\u308b
  textFont(myFontSmall);
	fill(255);
	text("ch1:"+serialToCh[1]+"\n"+ "ch2:"+serialToCh[2]+"\n"+ "ch3:"+serialToCh[3]+"\n"+ "ch4:"+serialToCh[4]+"\n"+ "ch5:"+serialToCh[5]+"\n"+ "ch6:"+serialToCh[6]+"\n"+ "ch7:"+serialToCh[7]+"\n"+
	 "ch8:"+serialToCh[8]+"\n"+ "ch9:"+serialToCh[9]+"\n"+ "ch10:"+serialToCh[10]+"\n"+ "ch11:"+serialToCh[11]+"\n"+ "ch12:"+serialToCh[12]+"\n",280,68);
	
	//\u30cd\u30c3\u30c8\u304b\u3089\u53d6\u5f97\u3057\u305f\u30c1\u30e3\u30f3\u30cd\u30eb\u60c5\u5831\u306e\u8868\u793a
	for(int i=1;i<=12;i++){
		//\u3082\u3057\u9078\u629e\u4e2d\u306e\u30dc\u30bf\u30f3\u3068\u3001\u3053\u308c\u304b\u3089\u63cf\u753b\u3059\u308b\u30c6\u30ad\u30b9\u30c8\u306e\u9806\u756a\u304c\u7b49\u3057\u3051\u308c\u3070
		if(chToFeedNumb[currSelectedCh]==i){
			fill(255);
		}else{
			fill(180);
		}
		text(chTitleData[i]+"\n",430,90+i*18);
	}

	//\u30c1\u30e3\u30f3\u30cd\u30eb\u3068xml\u5408\u308f\u305b\u30c7\u30fc\u30bf\u306e\u8868\u793a \u78ba\u8a8d\u7528
	textFont(myFontSmall);
	fill(180);
	text("chToFeedNumb " ,400,580);
	//chTofeednumb\u914d\u5217\u306e\u4e2d\u8eab\u8868\u793a
	for(int i=0;i<chToFeedNumb.length;i++){
		text(chToFeedNumb[i],15*i+400,600);		
	}
	
	//\u30b3\u30e1\u30f3\u30c8\u8868\u793a
	textFont(myFontSmall);
	fill(255);
	text("1.\u8996\u8074\u3057\u3066\u3044\u308b\u5730\u57df\u3092\n\u9078\u629e\u3057\u3066\u304f\u3060\u3055\u3044",20,20);
	text("2.\u30dc\u30c3\u30af\u30b9\u3092\u30af\u30ea\u30c3\u30af\u3057\u3001\n\u30ea\u30e2\u30b3\u30f3\u3092\u767a\u5149\u3055\u305b\u30661ch\u304b\u308912ch\u307e\u3067\n\u8a18\u9332\u3057\u3066\u304f\u3060\u3055\u3044\u3002",180,20);
	text("4.save&quit\u3092\u62bc\u3057\u3001\n\u3053\u306e\u30d7\u30ed\u30b0\u30e9\u30e0\u3068\u540c\u3058\u30d5\u30a9\u30eb\u30c0\u306b\u51fa\u529b\u3055\u308c\u308b\nTakeMeToTheRemoconTwitFolder.pde\u3092\nremoconTwit.pde\u3068\u540c\u3058\u30d5\u30a9\u30eb\u30c0\u306b\n\u30b3\u30d4\u30fc\u3057\u3066\u304f\u3060\u3055\u3044",720,20);
	fill(180);
	text("(3.\u30ea\u30e2\u30b3\u30f3\u578b\u306e\u30de\u30b9\u304b\u3089\u8a2d\u5b9a\u3059\u308b\u30ea\u30e2\u30b3\u30f3\u306e\u30dc\u30bf\u30f3\u3092\u9078\u3073\n\u30ea\u30b9\u30c8\u304b\u3089\u5bfe\u5fdc\u3059\u308b\u653e\u9001\u5c40\u3092\u3092\u63a2\u3057\u3066\u3001\n\u8a2d\u5b9a\u3068\u7570\u306a\u308b\u5834\u5408\u306f\u884c\u982d\u306e\u30dc\u30bf\u30f3\u3092\u30af\u30ea\u30c3\u30af\u3057\u3066\u9078\u629e\u304f\u3060\u3055\u3044)",400,20);
	
}

//\u30a4\u30f3\u30bf\u30fc\u30cd\u30c3\u30c8\u4e0a\u304b\u3089\u653e\u9001\u5c40\u540d\u3092\u53d6\u5f97\u3059\u308b
public int getChFromTitle(String title){
	int gotCh=0;
	try{
		String string = title;//"5/6 16:53\uff5e19:00 [\u30c6\u30ec\u30d3\u671d\u65e5(Ch.15)]";
		String regex = "[ch\\.]\\d{1,2}";
		Pattern p = Pattern.compile(regex);
		Matcher m = p.matcher(string);

		if (m.find()){
		  String s = string.substring(m.start(), m.end());

		  String regex2 = "\\d{1,2}";
		  Pattern p2 = Pattern.compile(regex2);
		  Matcher m2 = p2.matcher(s);

		  if(m2.find()){
		    String sChXml = s.substring(m2.start(),m2.end());
		    int chXml = Integer.valueOf(sChXml);
				gotCh = chXml;
		  }

		}
		return gotCh;
	}catch(NullPointerException n){
		return gotCh;
	}

}


//\u4f55\u304b\u5909\u5316\u304c\u3042\u3063\u305f\u30e9\u30b8\u30aa\u30dc\u30bf\u30f3\u306e\u756a\u53f7\u3092\u304b\u3048\u3059
public void radio(int theID) {
  switch(theID) {
    case(0):
			currSelectRadio = 0;
      break;  
    case(1):
			currSelectRadio = 1;
      break;  
    case(2):
			currSelectRadio = 2;
      break;  
    case(3):
			currSelectRadio = 3;
      break;  
    case(4):
			currSelectRadio = 4;
      break;
    case(5):
			currSelectRadio = 5;
      break;  
    case(6):
			currSelectRadio = 6;
      break;  
    case(7):
			currSelectRadio = 7;
      break;  
    case(8):
			currSelectRadio = 8;
      break;  
    case(9):
			currSelectRadio = 9;
      break;
    case(10):
			currSelectRadio = 10;
      break;  
    case(11):
			currSelectRadio = 11;
      break;  
  }
}

//\u30e9\u30b8\u30aa\u30dc\u30bf\u30f3\u306b\u30c8\u30b0\u30eb\u3092\u3064\u3051\u308b
public void addToRadioButton(RadioButton theRadioButton, String theName, int theValue ) {
  Toggle t = theRadioButton.addItem(theName,theValue);
}


//\u30a4\u30f3\u30bf\u30fc\u30d5\u30a7\u30fc\u30b9\u30a4\u30d9\u30f3\u30c8\u3092\u76e3\u8996
public void controlEvent(ControlEvent theEvent) {
	//chList\u306b\u5909\u5316\u304c\u3042\u308c\u3070
  if (theEvent.isGroup()&&theEvent.name()=="chList") {
		l.captionLabel().set(theEvent.group().stringValue());
		AREAID =  String.valueOf(PApplet.parseInt(theEvent.group().value()));
		chTitleData = getTitle("http://tv.so-net.ne.jp/rss/schedulesByCurrentTime.action?group=10&stationAreaId="+AREAID);
		
		//\u30c1\u30e3\u30f3\u30cd\u30eb\u3068xml\u3092\u5408\u308f\u305b\u308b\u3002
		for(int i=1;i<12;i++){
			chToFeedNumb[i] =0;
			for(int j=1;j<12;j++){
				//\u3082\u3057\u756a\u7d44\u30c1\u30e3\u30f3\u30cd\u30eb\u540d\u3068xml\u756a\u53f7\u304c\u4e00\u81f4\u3059\u308b\u306a\u3089\u4ee3\u5165\u3059\u308b
				if(i==getChFromTitle(chTitleData[j])){
					chToFeedNumb[i] = j;
				}
			}
		}
  }

	//\u30c1\u30e3\u30f3\u30cd\u30eb\u30e9\u30b8\u30aa\u30dc\u30bf\u30f3\u306b\u5909\u5316\u304c\u3042\u308c\u3070
	if(theEvent.isGroup()&&theEvent.name()=="chRadioBtn"){
		currSelectedCh = PApplet.parseInt(theEvent.group().stringValue());
		currSelectedXml = 0;
	}
	
	//\u30dc\u30bf\u30f3\u304c\u62bc\u3055\u308c\u305f\u3089
	for(int i=1;i<=12;i++){
		if(i==PApplet.parseInt(trim(theEvent.name()))){
			chToFeedNumb[currSelectedCh] = i;
		}
	}
}


//\u30bb\u30c3\u30c6\u30a3\u30f3\u30b0\u3092\u8a18\u9332\u3059\u308b
public void saveSetting(int theValue) {
  saveStr[0] = "int[] chToFeedNumbO = {"+chToFeedNumb[0]+","+chToFeedNumb[1]+","+chToFeedNumb[2]+","+chToFeedNumb[3]+","+chToFeedNumb[4]+","+chToFeedNumb[5]+","+chToFeedNumb[6]+","+chToFeedNumb[7]+","+chToFeedNumb[8]+","+chToFeedNumb[9]+","+chToFeedNumb[10]+","+chToFeedNumb[11]+","+chToFeedNumb[12]+"};";
  saveStr[1] = "int[] serialToChO = {"+serialToCh[0]+","+serialToCh[1]+","+serialToCh[2]+","+serialToCh[3]+","+serialToCh[4]+","+serialToCh[5]+","+serialToCh[6]+","+serialToCh[7]+","+serialToCh[8]+","+serialToCh[9]+","+serialToCh[10]+","+serialToCh[11]+","+serialToCh[12]+"};";
  saveStr[2] = "String feedURLO = \"http://tv.so-net.ne.jp/rss/schedulesByCurrentTime.action?group=10&stationAreaId="+AREAID+"\";";
	
	println("Save button pressed "+theValue);
	saveStrings("TakeMeToTheRemoconTwitFolder.pde", saveStr);
	exit();
}



//\u30bf\u30a4\u30c8\u30eb\u60c5\u5831\u3092\u8fd4\u3059
public String[] getTitle(String url){	
  String[] chTitle = new String[13];
	try{
		XMLElement rss = new XMLElement(this, url);
		XMLElement item;
		XMLElement titleElement;

		for(int i=0;i<12;i++){
		  item = rss.getChild(i);
		  titleElement = item.getChild(2);
		  chTitle[i] = titleElement.getContent();
		}
	
		return chTitle;
	}catch(ArrayIndexOutOfBoundsException e){
		return chTitle;
	}
}
int[] chToFeedNumbO = {0,3,4,7,0,1,2,6,5,0,0,0,0};
int[] serialToChO = {0,3017,527305,265161,789449,134089,658377,396233,920521,68553,592841,330697,854985};
String feedURLO = "http://tv.so-net.ne.jp/rss/schedulesByCurrentTime.action?group=10&stationAreaId=12";

  static public void main(String args[]) {
    PApplet.main(new String[] { "--bgcolor=#FFFFFF", "remoconUtil" });
  }
}
