/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.ControlP5;
import controlP5.ControlP5XMLElement;
import controlP5.Controller;
import controlP5.ControllerGroup;
import controlP5.Label;
import controlP5.TickMark;
import java.util.Vector;
import processing.core.PApplet;

public class Slider
extends Controller {
    private int _myDirection;
    public static final int FIX = 1;
    public static final int FLEXIBLE = 0;
    protected int _mySliderMode = 1;
    protected float _myValuePosition;
    protected float _mySliderbarSize = 0.0f;
    protected Vector<TickMark> _myTickMarks;
    protected boolean isShowTickMarks;
    protected boolean isSnapToTickMarks;
    protected static int autoWidth = 200;
    protected static int autoHeight = 10;
    public int alignValueLabel = 3;
    public int valueLabelPositioning = 1;

    public Slider(ControlP5 controlP5, ControllerGroup controllerGroup, String string, float f, float f2, float f3, int n, int n2, int n3, int n4) {
        super(controlP5, controllerGroup, string, n, n2, n3, n4);
        this._myCaptionLabel = new Label(string, this.color.colorLabel);
        this._myMin = f;
        this._myMax = f2;
        this._myValueLabel = new Label("" + (this.adjustValue(this._myMax).length() > this.adjustValue(this._myMin).length() ? this.adjustValue(this._myMax) : this.adjustValue(this._myMin)), this.color.colorValue);
        this._myValueLabel.set("" + this.adjustValue(this._myValue));
        this._myValue = f3;
        this._myTickMarks = new Vector();
        this.setSliderMode(1);
        int n5 = this._myDirection = this.width > this.height ? 0 : 1;
        if (this._myDirection == 0) {
            this.alignValueLabel = 3;
            this.valueLabelPositioning = 1;
        } else {
            this.valueLabelPositioning = 0;
        }
        this.valueLabel();
    }

    public void setSliderMode(int n) {
        this._mySliderMode = n;
        this._mySliderbarSize = this._mySliderMode == 0 ? 10.0f : 0.0f;
        this._myUnit = (this._myMax - this._myMin) / (this.width > this.height ? (float)this.width - this._mySliderbarSize : (float)this.height - this._mySliderbarSize);
        this.setValue(this._myValue);
    }

    public void updateInternalEvents(PApplet pApplet) {
        if (this.isVisible && this.isMousePressed && !ControlP5.keyHandler.isAltDown) {
            if (this._myDirection == 0) {
                this.setValue(this._myMin + ((float)this._myControlWindow.mouseX - (this._myParent.absolutePosition().x() + this.position.x)) * this._myUnit);
            } else {
                this.setValue(this._myMin + -((float)this._myControlWindow.mouseY - (this._myParent.absolutePosition().y() + this.position.y) - (float)this.height) * this._myUnit);
            }
        }
    }

    public void draw(PApplet pApplet) {
        if (this.isVisible) {
            pApplet.pushMatrix();
            pApplet.translate(this.position().x(), this.position().y());
            pApplet.fill(this.color.colorBackground);
            pApplet.noStroke();
            pApplet.rect(0.0f, 0.0f, (float)this.width, (float)this.height);
            pApplet.fill(this.getIsInside() ? this.color.colorActive : this.color.colorForeground);
            if (this._myDirection == 0) {
                if (this._mySliderMode == 1) {
                    pApplet.rect(0.0f, 0.0f, this._myValuePosition, (float)this.height);
                } else if (this.isShowTickMarks) {
                    pApplet.triangle(this._myValuePosition, 0.0f, this._myValuePosition + this._mySliderbarSize, 0.0f, this._myValuePosition + this._mySliderbarSize / 2.0f, (float)this.height);
                } else {
                    pApplet.rect(this._myValuePosition, 0.0f, this._mySliderbarSize, (float)this.height);
                }
            } else if (this._mySliderMode == 1) {
                pApplet.rect(0.0f, (float)this.height, (float)this.width, -this._myValuePosition);
            } else if (this.isShowTickMarks) {
                pApplet.triangle((float)this.width, (float)this.height - this._myValuePosition, (float)this.width, (float)this.height - this._myValuePosition - this._mySliderbarSize, 0.0f, (float)this.height - this._myValuePosition - this._mySliderbarSize / 2.0f);
            } else {
                pApplet.rect(0.0f, (float)this.height - this._myValuePosition - this._mySliderbarSize, (float)this.width, this._mySliderbarSize);
            }
            if (this.isLabelVisible) {
                int n = 0;
                int n2 = 0;
                if (this._myDirection == 0) {
                    this._myCaptionLabel.draw(pApplet, this.width + 3, this.height / 2 - 3);
                    switch (this.alignValueLabel) {
                        case 1: {
                            n = -10;
                            break;
                        }
                        default: {
                            n = this.height / 2 - 3;
                            n2 = 3;
                            break;
                        }
                        case 2: {
                            n = this.height + 3;
                        }
                    }
                    this._myValueLabel.draw(pApplet, this.valueLabelPositioning == 1 ? n2 : (int)this._myValuePosition, n);
                } else {
                    this._myCaptionLabel.draw(pApplet, 0, this.height + 3);
                    switch (this.alignValueLabel) {
                        default: {
                            n = -10;
                            break;
                        }
                        case 3: {
                            n = this.height / 2 - 3;
                            n2 = 3;
                            break;
                        }
                        case 2: {
                            n = this.height + 3;
                        }
                    }
                    this._myValueLabel.draw(pApplet, this.valueLabelPositioning == 1 ? 0 : this.width + 4, this.valueLabelPositioning == 1 ? n : -((int)this._myValuePosition) + this.height - 8);
                }
            }
            if (this.isShowTickMarks) {
                float f;
                pApplet.pushStyle();
                pApplet.pushMatrix();
                float f2 = f = this._myDirection == 0 ? (float)this.getWidth() : (float)this.getHeight();
                if (this._myDirection == 0) {
                    pApplet.translate(this._mySliderMode == 1 ? 0.0f : this._mySliderbarSize / 2.0f, (float)this.getHeight());
                } else {
                    pApplet.translate(-4.0f, this._mySliderMode == 1 ? 0.0f : this._mySliderbarSize / 2.0f);
                }
                float f3 = (f - (this._mySliderMode == 1 ? 0.0f : this._mySliderbarSize)) / (float)(this._myTickMarks.size() - 1);
                for (TickMark tickMark : this._myTickMarks) {
                    tickMark.draw(pApplet, this._myDirection);
                    if (this._myDirection == 0) {
                        pApplet.translate(f3, 0.0f);
                        continue;
                    }
                    pApplet.translate(0.0f, f3);
                }
                pApplet.popMatrix();
                pApplet.popStyle();
            }
            pApplet.popMatrix();
        }
    }

    protected void snapValue(float f) {
        if (this.isSnapToTickMarks) {
            this._myValuePosition = (this._myValue - this._myMin) / this._myUnit;
            float f2 = PApplet.round((float)PApplet.map((float)this._myValuePosition, (float)0.0f, (float)(this._myDirection == 0 ? (float)this.getWidth() : (float)this.getHeight()), (float)0.0f, (float)(this._myTickMarks.size() - 1)));
            this._myValue = PApplet.map((float)f2, (float)0.0f, (float)(this._myTickMarks.size() - 1), (float)this._myMin, (float)this._myMax);
        }
    }

    public void setValue(float f) {
        this._myValue = f;
        this.snapValue(this._myValue);
        this._myValue = this._myValue <= this._myMin ? this._myMin : this._myValue;
        this._myValue = this._myValue >= this._myMax ? this._myMax : this._myValue;
        this._myValuePosition = (this._myValue - this._myMin) / this._myUnit;
        this._myValueLabel.set(this.adjustValue(this._myValue));
        this.broadcast(1);
    }

    public void update() {
        this.setValue(this._myValue);
    }

    public void setMin(float f) {
        this._myMin = f;
        this.setSliderMode(this._mySliderMode);
    }

    public void setMax(float f) {
        this._myMax = f;
        this.setSliderMode(this._mySliderMode);
    }

    public Controller setWidth(int n) {
        this.width = n;
        this.setSliderMode(this._mySliderMode);
        return this;
    }

    public Controller setHeight(int n) {
        this.height = n;
        this.setSliderMode(this._mySliderMode);
        return this;
    }

    public void addToXMLElement(ControlP5XMLElement controlP5XMLElement) {
        controlP5XMLElement.setAttribute("type", "slider");
        controlP5XMLElement.setAttribute("min", new Float(this.min()));
        controlP5XMLElement.setAttribute("max", new Float(this.max()));
    }

    public void onEnter() {
    }

    public void onLeave() {
    }

    protected void setTickMarks() {
    }

    public void setNumberOfTickMarks(int n) {
        int n2 = n - this._myTickMarks.size();
        if (n2 <= n) {
            for (int i = 0; i < n2; ++i) {
                this._myTickMarks.add(new TickMark(this));
            }
        }
        this.showTickMarks(true);
        this.snapToTickMarks(true);
        this.setValue(this._myValue);
    }

    public void showTickMarks(boolean bl) {
        this.isShowTickMarks = bl;
    }

    public void snapToTickMarks(boolean bl) {
        this.isSnapToTickMarks = bl;
    }

    public TickMark getTickMark() {
        return null;
    }

    public void alignValueLabel(int n) {
        this.alignValueLabel = n;
    }

    public Controller linebreak() {
        this.controlP5.linebreak(this, true, autoWidth, autoHeight, this.autoSpacing);
        return this;
    }
}

