/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.http;

import twitter4j.http.HttpClient;
import twitter4j.http.HttpRequest;
import twitter4j.http.HttpResponse;

public class HttpResponseEvent {
    private HttpRequest request;
    private HttpClient source;
    private HttpResponse response;

    HttpResponseEvent(HttpClient source, HttpRequest request, HttpResponse response) {
        this.source = source;
        this.request = request;
        this.response = response;
    }

    public HttpRequest getRequest() {
        return this.request;
    }

    public HttpResponse getResponse() {
        return this.response;
    }

    public boolean isAuthenticated() {
        return this.request.authorization.isEnabled();
    }

    public HttpClient getSource() {
        return this.source;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpResponseEvent that = (HttpResponseEvent)o;
        if (this.request != null ? !this.request.equals(that.request) : that.request != null) {
            return false;
        }
        return !(this.response != null ? !this.response.equals(that.response) : that.response != null);
    }

    public int hashCode() {
        int result = this.request != null ? this.request.hashCode() : 0;
        result = 31 * result + (this.response != null ? this.response.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "HttpResponseEvent{request=" + this.request + ", response=" + this.response + '}';
    }
}

