/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.http;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import twitter4j.TwitterException;
import twitter4j.logging.Logger;
import twitter4j.org.json.JSONArray;
import twitter4j.org.json.JSONException;
import twitter4j.org.json.JSONObject;

public class HttpResponse {
    private static final Logger logger = Logger.getLogger();
    private static ThreadLocal<DocumentBuilder> builders = new ThreadLocal<DocumentBuilder>(){

        @Override
        protected DocumentBuilder initialValue() {
            try {
                return DocumentBuilderFactory.newInstance().newDocumentBuilder();
            }
            catch (ParserConfigurationException ex) {
                throw new ExceptionInInitializerError(ex);
            }
        }

        @Override
        protected /* synthetic */ Object initialValue() {
            return this.initialValue();
        }
    };
    private int statusCode;
    private Document responseAsDocument = null;
    private String responseAsString = null;
    private InputStream is;
    private HttpURLConnection con;
    private boolean streamConsumed = false;

    public HttpResponse(HttpURLConnection con) throws IOException {
        this.con = con;
        this.statusCode = con.getResponseCode();
        this.is = con.getErrorStream();
        if (null == this.is) {
            this.is = con.getInputStream();
        }
        if (null != this.is && "gzip".equals(con.getContentEncoding())) {
            this.is = new GZIPInputStream(this.is);
        }
    }

    HttpResponse(String content) {
        this.responseAsString = content;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getResponseHeader(String name) {
        return this.con.getHeaderField(name);
    }

    public InputStream asStream() {
        if (this.streamConsumed) {
            throw new IllegalStateException("Stream has already been consumed.");
        }
        return this.is;
    }

    public String asString() throws TwitterException {
        if (null == this.responseAsString) {
            try {
                String line;
                InputStream stream = this.asStream();
                if (null == stream) {
                    return null;
                }
                BufferedReader br = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
                StringBuffer buf = new StringBuffer();
                while (null != (line = br.readLine())) {
                    buf.append(line).append("\n");
                }
                this.responseAsString = buf.toString();
                logger.debug(this.responseAsString);
                stream.close();
                this.con.disconnect();
                this.streamConsumed = true;
            }
            catch (NullPointerException npe) {
                throw new TwitterException(npe.getMessage(), npe);
            }
            catch (IOException ioe) {
                throw new TwitterException(ioe.getMessage(), ioe);
            }
        }
        return this.responseAsString;
    }

    public Document asDocument() throws TwitterException {
        if (null == this.responseAsDocument) {
            try {
                this.responseAsDocument = builders.get().parse(new ByteArrayInputStream(this.asString().getBytes("UTF-8")));
            }
            catch (SAXException saxe) {
                throw new TwitterException("The response body was not well-formed:\n" + this.responseAsString, saxe);
            }
            catch (IOException ioe) {
                throw new TwitterException("There's something with the connection.", ioe);
            }
        }
        return this.responseAsDocument;
    }

    public JSONObject asJSONObject() throws TwitterException {
        try {
            return new JSONObject(this.asString());
        }
        catch (JSONException jsone) {
            throw new TwitterException(jsone.getMessage() + ":" + this.responseAsString, jsone);
        }
    }

    public JSONArray asJSONArray() throws TwitterException {
        try {
            return new JSONArray(this.asString());
        }
        catch (JSONException jsone) {
            throw new TwitterException(jsone.getMessage() + ":" + this.responseAsString, jsone);
        }
    }

    public InputStreamReader asReader() {
        try {
            return new InputStreamReader(this.is, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            return new InputStreamReader(this.is);
        }
    }

    public void disconnect() {
        this.con.disconnect();
    }

    public String toString() {
        if (null != this.responseAsString) {
            return this.responseAsString;
        }
        return "Response{statusCode=" + this.statusCode + ", response=" + this.responseAsDocument + ", responseString='" + this.responseAsString + '\'' + ", is=" + this.is + ", con=" + this.con + '}';
    }
}

