/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.examples;

import twitter4j.Status;
import twitter4j.StatusDeletionNotice;
import twitter4j.StatusListener;
import twitter4j.TwitterException;
import twitter4j.TwitterStream;

public class StreamingExample
implements StatusListener {
    TwitterStream twitterStream;

    public static void main(String[] args) throws TwitterException {
        if (args.length < 2) {
            System.out.println("Usage: java twitter4j.examples.StreamingExample ID Password");
            System.exit(-1);
        }
        StreamingExample streamingExample = new StreamingExample(args[0], args[1]);
        streamingExample.startConsuming();
    }

    StreamingExample(String id, String password) {
        this.twitterStream = new TwitterStream(id, password);
        this.twitterStream.setStatusListener(this);
    }

    private void startConsuming() throws TwitterException {
        this.twitterStream.sample();
    }

    public void onStatus(Status status) {
        System.out.println(status.getUser().getName() + " : " + status.getText());
    }

    public void onDeletionNotice(StatusDeletionNotice statusDeletionNotice) {
    }

    public void onTrackLimitationNotice(int numberOfLimitedStatuses) {
    }

    public void onException(Exception ex) {
        ex.printStackTrace();
    }
}

