/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import twitter4j.StatusListener;
import twitter4j.StatusStream;
import twitter4j.StreamingReadTimeoutConfiguration;
import twitter4j.TwitterBase;
import twitter4j.TwitterException;
import twitter4j.conf.Configuration;
import twitter4j.conf.ConfigurationContext;
import twitter4j.http.Authorization;
import twitter4j.http.HttpClientWrapper;
import twitter4j.http.HttpParameter;
import twitter4j.logging.Logger;

public class TwitterStream
extends TwitterBase
implements Serializable {
    private final HttpClientWrapper http;
    private static final Logger logger = Logger.getLogger();
    private StatusListener statusListener;
    private StreamHandlingThread handler = null;
    private int retryPerMinutes = 1;
    private static final long serialVersionUID = -762817147320767897L;

    public TwitterStream() {
        super(ConfigurationContext.getInstance());
        this.http = new HttpClientWrapper(new StreamingReadTimeoutConfiguration(this.conf));
        this.ensureBasicEnabled();
    }

    public TwitterStream(String screenName, String password) {
        super(ConfigurationContext.getInstance(), screenName, password);
        this.http = new HttpClientWrapper(new StreamingReadTimeoutConfiguration(this.conf));
        this.ensureBasicEnabled();
    }

    public TwitterStream(String screenName, String password, StatusListener listener) {
        super(ConfigurationContext.getInstance(), screenName, password);
        this.statusListener = listener;
        this.http = new HttpClientWrapper(new StreamingReadTimeoutConfiguration(this.conf));
        this.ensureBasicEnabled();
    }

    TwitterStream(Configuration conf, Authorization auth, StatusListener listener) {
        super(conf, auth);
        this.http = new HttpClientWrapper(new StreamingReadTimeoutConfiguration(conf));
        this.statusListener = listener;
        this.ensureBasicEnabled();
    }

    public void firehose(int count) throws TwitterException {
        this.startHandler(new StreamHandlingThread(new Object[]{new Integer(count)}){

            public StatusStream getStream() throws TwitterException {
                return TwitterStream.this.getFirehoseStream((Integer)this.args[0]);
            }
        });
    }

    public StatusStream getFirehoseStream(int count) throws TwitterException {
        this.ensureBasicEnabled();
        try {
            return new StatusStream(this.http.post(this.conf.getStreamBaseURL() + "statuses/firehose.json", new HttpParameter[]{new HttpParameter("count", String.valueOf(count))}, this.auth));
        }
        catch (IOException e) {
            throw new TwitterException(e);
        }
    }

    public void retweet() throws TwitterException {
        this.ensureBasicEnabled();
        this.startHandler(new StreamHandlingThread(new Object[0]){

            public StatusStream getStream() throws TwitterException {
                return TwitterStream.this.getRetweetStream();
            }
        });
    }

    public StatusStream getRetweetStream() throws TwitterException {
        this.ensureAuthorizationEnabled();
        try {
            return new StatusStream(this.http.post(this.conf.getStreamBaseURL() + "statuses/retweet.json", new HttpParameter[0], this.auth));
        }
        catch (IOException e) {
            throw new TwitterException(e);
        }
    }

    public void sample() throws TwitterException {
        this.ensureBasicEnabled();
        this.startHandler(new StreamHandlingThread(null){

            public StatusStream getStream() throws TwitterException {
                return TwitterStream.this.getSampleStream();
            }
        });
    }

    public StatusStream getSampleStream() throws TwitterException {
        this.ensureBasicEnabled();
        try {
            return new StatusStream(this.http.get(this.conf.getStreamBaseURL() + "statuses/sample.json", this.auth));
        }
        catch (IOException e) {
            throw new TwitterException(e);
        }
    }

    public void filter(int count, int[] follow, String[] track) throws TwitterException {
        this.startHandler(new StreamHandlingThread(new Object[]{new Integer(count), follow, track}){

            public StatusStream getStream() throws TwitterException {
                return TwitterStream.this.getFilterStream((Integer)this.args[0], (int[])this.args[1], (String[])this.args[2]);
            }
        });
    }

    public StatusStream getFilterStream(int count, int[] follow, String[] track) throws TwitterException {
        this.ensureBasicEnabled();
        ArrayList<HttpParameter> postparams = new ArrayList<HttpParameter>();
        postparams.add(new HttpParameter("count", count));
        if (null != follow && follow.length > 0) {
            postparams.add(new HttpParameter("follow", this.toFollowString(follow)));
        }
        if (null != track && track.length > 0) {
            postparams.add(new HttpParameter("track", this.toTrackString(track)));
        }
        try {
            return new StatusStream(this.http.post(this.conf.getStreamBaseURL() + "statuses/filter.json", postparams.toArray(new HttpParameter[postparams.size()]), this.auth));
        }
        catch (IOException e) {
            throw new TwitterException(e);
        }
    }

    private String toFollowString(int[] follows) {
        StringBuffer buf = new StringBuffer(11 * follows.length);
        int[] arr$ = follows;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int follow = arr$[i$];
            if (0 != buf.length()) {
                buf.append(",");
            }
            buf.append(follow);
        }
        return buf.toString();
    }

    private String toTrackString(String[] keywords) {
        StringBuffer buf = new StringBuffer(20 * keywords.length * 4);
        String[] arr$ = keywords;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            String keyword = arr$[i$];
            if (0 != buf.length()) {
                buf.append(",");
            }
            buf.append(keyword);
        }
        return buf.toString();
    }

    private synchronized void startHandler(StreamHandlingThread handler) throws TwitterException {
        this.cleanup();
        if (null == this.statusListener) {
            throw new IllegalStateException("StatusListener is not set.");
        }
        this.handler = handler;
        this.handler.start();
    }

    public synchronized void cleanup() {
        if (null != this.handler) {
            try {
                this.handler.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void setStatusListener(StatusListener statusListener) {
        this.statusListener = statusListener;
    }

    public /* synthetic */ String toString() {
        return super.toString();
    }

    public /* synthetic */ int hashCode() {
        return super.hashCode();
    }

    public /* synthetic */ boolean equals(Object x0) {
        return super.equals(x0);
    }

    public /* synthetic */ Authorization getAuthorization() {
        return super.getAuthorization();
    }

    public /* synthetic */ boolean isBasicAuthEnabled() {
        return super.isBasicAuthEnabled();
    }

    abstract class StreamHandlingThread
    extends Thread {
        StatusStream stream;
        Object[] args;
        private List<Long> retryHistory;
        private static final String NAME = "Twitter Stream Handling Thread";
        private boolean closed;

        StreamHandlingThread(Object[] args) {
            super("Twitter Stream Handling Thread[initializing]");
            this.stream = null;
            this.closed = false;
            this.args = args;
            this.retryHistory = new ArrayList<Long>(TwitterStream.this.retryPerMinutes);
        }

        public void run() {
            while (!this.closed) {
                try {
                    if (this.retryHistory.size() > 0 && System.currentTimeMillis() - this.retryHistory.get(0) > 60000L) {
                        this.retryHistory.remove(0);
                    }
                    if (this.retryHistory.size() < TwitterStream.this.retryPerMinutes) {
                        this.setStatus("[establishing connection]");
                        while (!this.closed && null == this.stream) {
                            if (this.retryHistory.size() >= TwitterStream.this.retryPerMinutes) continue;
                            this.retryHistory.add(new Long(System.currentTimeMillis()));
                            this.stream = this.getStream();
                        }
                    } else if (!this.closed) {
                        long timeToSleep = 60000L - (System.currentTimeMillis() - this.retryHistory.get(this.retryHistory.size() - 1));
                        this.setStatus("[retry limit reached. sleeping for " + timeToSleep / 1000L + " secs]");
                        try {
                            Thread.sleep(timeToSleep);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    if (null == this.stream) continue;
                    this.setStatus("[receiving stream]");
                    while (!this.closed) {
                        this.stream.next(TwitterStream.this.statusListener);
                    }
                }
                catch (TwitterException te) {
                    this.stream = null;
                    te.printStackTrace();
                    logger.debug(te.getMessage());
                    TwitterStream.this.statusListener.onException(te);
                }
            }
            try {
                this.stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public synchronized void close() throws IOException {
            this.setStatus("[disposing thread]");
            this.closed = true;
        }

        private void setStatus(String message) {
            String actualMessage = NAME + message;
            this.setName(actualMessage);
            logger.debug(actualMessage);
        }

        abstract StatusStream getStream() throws TwitterException;
    }
}

