/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import twitter4j.RateLimitStatus;
import twitter4j.RateLimitStatusEvent;
import twitter4j.RateLimitStatusJSONImpl;
import twitter4j.RateLimitStatusListener;
import twitter4j.TwitterBase;
import twitter4j.TwitterException;
import twitter4j.conf.Configuration;
import twitter4j.http.AccessToken;
import twitter4j.http.Authorization;
import twitter4j.http.HttpClientWrapper;
import twitter4j.http.HttpResponse;
import twitter4j.http.HttpResponseEvent;
import twitter4j.http.HttpResponseListener;
import twitter4j.http.NullAuthorization;
import twitter4j.http.OAuthAuthorization;
import twitter4j.http.OAuthSupport;
import twitter4j.http.RequestToken;

abstract class TwitterOAuthSupportBase
extends TwitterBase
implements HttpResponseListener,
OAuthSupport,
Serializable {
    protected transient HttpClientWrapper http;
    protected RateLimitStatusListener rateLimitStatusListener = null;
    private static final long serialVersionUID = 6960663978976449394L;

    TwitterOAuthSupportBase(Configuration conf) {
        super(conf);
        this.init();
    }

    TwitterOAuthSupportBase(Configuration conf, String screenName, String password) {
        super(conf, screenName, password);
        this.init();
    }

    TwitterOAuthSupportBase(Configuration conf, Authorization auth) {
        super(conf, auth);
        this.init();
    }

    private void init() {
        if (this.auth instanceof NullAuthorization) {
            String consumerKey = this.conf.getOAuthConsumerKey();
            String consumerSecret = this.conf.getOAuthConsumerSecret();
            if (null != consumerKey && null != consumerSecret) {
                OAuthAuthorization oauth = new OAuthAuthorization(this.conf, consumerKey, consumerSecret);
                String accessToken = this.conf.getOAuthAccessToken();
                String accessTokenSecret = this.conf.getOAuthAccessTokenSecret();
                if (null != accessToken && null != accessTokenSecret) {
                    oauth.setOAuthAccessToken(new AccessToken(accessToken, accessTokenSecret));
                }
                this.auth = oauth;
            }
        }
        this.http = new HttpClientWrapper(this.conf);
        this.http.setHttpResponseListener(this);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.rateLimitStatusListener instanceof Serializable) {
            out.writeObject(this.rateLimitStatusListener);
        } else {
            out.writeObject(null);
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.rateLimitStatusListener = (RateLimitStatusListener)stream.readObject();
        this.http = new HttpClientWrapper(this.conf);
        this.http.setHttpResponseListener(this);
    }

    public abstract void setOAuthConsumer(String var1, String var2);

    public abstract RequestToken getOAuthRequestToken() throws TwitterException;

    public abstract RequestToken getOAuthRequestToken(String var1) throws TwitterException;

    public abstract AccessToken getOAuthAccessToken() throws TwitterException;

    public abstract AccessToken getOAuthAccessToken(String var1) throws TwitterException;

    public abstract AccessToken getOAuthAccessToken(RequestToken var1) throws TwitterException;

    public abstract AccessToken getOAuthAccessToken(RequestToken var1, String var2) throws TwitterException;

    public abstract void setOAuthAccessToken(AccessToken var1);

    public abstract AccessToken getOAuthAccessToken(String var1, String var2) throws TwitterException;

    public abstract AccessToken getOAuthAccessToken(String var1, String var2, String var3) throws TwitterException;

    public abstract void setOAuthAccessToken(String var1, String var2);

    public boolean isOAuthEnabled() {
        return this.auth instanceof OAuthAuthorization && this.auth.isEnabled();
    }

    public void setRateLimitStatusListener(RateLimitStatusListener listener) {
        this.rateLimitStatusListener = listener;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TwitterOAuthSupportBase)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TwitterOAuthSupportBase that = (TwitterOAuthSupportBase)o;
        return !(this.rateLimitStatusListener != null ? !this.rateLimitStatusListener.equals(that.rateLimitStatusListener) : that.rateLimitStatusListener != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.rateLimitStatusListener != null ? this.rateLimitStatusListener.hashCode() : 0);
        return result;
    }

    public void httpResponseReceived(HttpResponseEvent event) {
        if (null != this.rateLimitStatusListener) {
            HttpResponse res = event.getResponse();
            RateLimitStatus rateLimitStatus = RateLimitStatusJSONImpl.createFromResponseHeader(res);
            RateLimitStatusEvent statusEvent = null;
            if (null != rateLimitStatus) {
                statusEvent = new RateLimitStatusEvent(this, rateLimitStatus, event.isAuthenticated());
                if (res.getStatusCode() == 420 || res.getStatusCode() == 503) {
                    this.rateLimitStatusListener.onRateLimitStatus(statusEvent);
                    this.rateLimitStatusListener.onRateLimitReached(statusEvent);
                } else {
                    this.rateLimitStatusListener.onRateLimitStatus(statusEvent);
                }
            }
        }
    }
}

