/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import twitter4j.ParseUtil;
import twitter4j.StatusDeletionNotice;
import twitter4j.StatusJSONImpl;
import twitter4j.StatusListener;
import twitter4j.TwitterException;
import twitter4j.http.HttpResponse;
import twitter4j.logging.Logger;
import twitter4j.org.json.JSONException;
import twitter4j.org.json.JSONObject;

public class StatusStream {
    private static final Logger logger = Logger.getLogger();
    private boolean streamAlive = true;
    private BufferedReader br;
    private InputStream is;
    private HttpResponse response;

    StatusStream(InputStream stream) throws IOException {
        this.is = stream;
        this.br = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
    }

    StatusStream(HttpResponse response) throws IOException {
        this(response.asStream());
        this.response = response;
    }

    public void next(StatusListener listener) throws TwitterException {
        block12: {
            if (!this.streamAlive) {
                throw new IllegalStateException("Stream already closed.");
            }
            try {
                String line = this.br.readLine();
                if (null == line || line.length() <= 0) break block12;
                logger.debug("received:", line);
                try {
                    JSONObject json = new JSONObject(line);
                    if (!json.isNull("text")) {
                        listener.onStatus(new StatusJSONImpl(json));
                    } else if (!json.isNull("delete")) {
                        listener.onDeletionNotice(new StatusDeletionNotice(json));
                    } else if (!json.isNull("limit")) {
                        listener.onTrackLimitationNotice(ParseUtil.getInt("track", json.getJSONObject("limit")));
                    }
                }
                catch (JSONException ex) {
                    listener.onException(ex);
                }
            }
            catch (IOException e) {
                try {
                    this.is.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.streamAlive = false;
                throw new TwitterException("Stream closed.", e);
            }
        }
    }

    public void close() throws IOException {
        this.is.close();
        this.br.close();
        if (null != this.response) {
            this.response.disconnect();
        }
    }
}

