/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.Serializable;
import twitter4j.ParseUtil;
import twitter4j.Relationship;
import twitter4j.TwitterException;
import twitter4j.TwitterResponseImpl;
import twitter4j.http.HttpResponse;
import twitter4j.org.json.JSONException;
import twitter4j.org.json.JSONObject;

final class RelationshipJSONImpl
extends TwitterResponseImpl
implements Relationship,
Serializable {
    private int targetUserId;
    private String targetUserScreenName;
    private boolean sourceBlockingTarget;
    private boolean sourceNotificationsEnabled;
    private boolean sourceFollowingTarget;
    private boolean sourceFollowedByTarget;
    private int sourceUserId;
    private String sourceUserScreenName;
    private static final long serialVersionUID = 697705345506281849L;

    RelationshipJSONImpl(HttpResponse res) throws TwitterException {
        super(res);
        this.init(res.asJSONObject());
    }

    RelationshipJSONImpl(JSONObject json) throws TwitterException {
        this.init(json);
    }

    private void init(JSONObject json) throws TwitterException {
        try {
            JSONObject relationship = json.getJSONObject("relationship");
            JSONObject sourceJson = relationship.getJSONObject("source");
            JSONObject targetJson = relationship.getJSONObject("target");
            this.sourceUserId = ParseUtil.getInt("id", sourceJson);
            this.targetUserId = ParseUtil.getInt("id", targetJson);
            this.sourceUserScreenName = ParseUtil.getUnescapedString("screen_name", sourceJson);
            this.targetUserScreenName = ParseUtil.getUnescapedString("screen_name", targetJson);
            this.sourceBlockingTarget = ParseUtil.getBoolean("blocking", sourceJson);
            this.sourceFollowingTarget = ParseUtil.getBoolean("following", sourceJson);
            this.sourceFollowedByTarget = ParseUtil.getBoolean("followed_by", sourceJson);
            this.sourceNotificationsEnabled = ParseUtil.getBoolean("notifications_enabled", sourceJson);
        }
        catch (JSONException jsone) {
            throw new TwitterException(jsone.getMessage() + ":" + json.toString(), jsone);
        }
    }

    public int getSourceUserId() {
        return this.sourceUserId;
    }

    public int getTargetUserId() {
        return this.targetUserId;
    }

    public boolean isSourceBlockingTarget() {
        return this.sourceBlockingTarget;
    }

    public String getSourceUserScreenName() {
        return this.sourceUserScreenName;
    }

    public String getTargetUserScreenName() {
        return this.targetUserScreenName;
    }

    public boolean isSourceFollowingTarget() {
        return this.sourceFollowingTarget;
    }

    public boolean isTargetFollowingSource() {
        return this.sourceFollowedByTarget;
    }

    public boolean isSourceFollowedByTarget() {
        return this.sourceFollowedByTarget;
    }

    public boolean isTargetFollowedBySource() {
        return this.sourceFollowingTarget;
    }

    public boolean isSourceNotificationsEnabled() {
        return this.sourceNotificationsEnabled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Relationship)) {
            return false;
        }
        Relationship that = (Relationship)o;
        if (this.sourceUserId != that.getSourceUserId()) {
            return false;
        }
        if (this.targetUserId != that.getTargetUserId()) {
            return false;
        }
        if (!this.sourceUserScreenName.equals(that.getSourceUserScreenName())) {
            return false;
        }
        return this.targetUserScreenName.equals(that.getTargetUserScreenName());
    }

    public int hashCode() {
        int result = this.sourceUserId;
        result = 31 * result + this.targetUserId;
        result = 31 * result + this.sourceUserScreenName.hashCode();
        result = 31 * result + this.targetUserScreenName.hashCode();
        return result;
    }

    public String toString() {
        return "RelationshipJSONImpl{sourceUserId=" + this.sourceUserId + ", targetUserId=" + this.targetUserId + ", sourceUserScreenName='" + this.sourceUserScreenName + '\'' + ", targetUserScreenName='" + this.targetUserScreenName + '\'' + ", sourceFollowingTarget=" + this.sourceFollowingTarget + ", sourceFollowedByTarget=" + this.sourceFollowedByTarget + ", sourceNotificationsEnabled=" + this.sourceNotificationsEnabled + '}';
    }
}

