/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.util.ArrayList;
import java.util.List;
import twitter4j.GeoLocation;
import twitter4j.http.HttpParameter;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Query {
    private String query = null;
    private String lang = null;
    private int rpp = -1;
    private int page = -1;
    private long sinceId = -1L;
    private String geocode = null;
    public static final String MILES = "mi";
    public static final String KILOMETERS = "km";

    public Query() {
    }

    public Query(String query) {
        this.query = query;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public Query query(String query) {
        this.setQuery(query);
        return this;
    }

    public String getLang() {
        return this.lang;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    public Query lang(String lang) {
        this.setLang(lang);
        return this;
    }

    public int getRpp() {
        return this.rpp;
    }

    public void setRpp(int rpp) {
        this.rpp = rpp;
    }

    public Query rpp(int rpp) {
        this.setRpp(rpp);
        return this;
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public Query page(int page) {
        this.setPage(page);
        return this;
    }

    public long getSinceId() {
        return this.sinceId;
    }

    public void setSinceId(long sinceId) {
        this.sinceId = sinceId;
    }

    public Query sinceId(long sinceId) {
        this.setSinceId(sinceId);
        return this;
    }

    public String getGeocode() {
        return this.geocode;
    }

    public void setGeoCode(GeoLocation location, double radius, String unit) {
        this.geocode = new StringBuffer().append(location.getLatitude()).append(",").append(location.getLongitude()).append(",").append(radius).append(unit).toString();
    }

    public Query geoCode(GeoLocation location, double radius, String unit) {
        this.setGeoCode(location, radius, unit);
        return this;
    }

    public HttpParameter[] asPostParameters() {
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
        this.appendParameter("q", this.query, params);
        this.appendParameter("lang", this.lang, params);
        this.appendParameter("rpp", this.rpp, params);
        this.appendParameter("page", this.page, params);
        this.appendParameter("since_id", this.sinceId, params);
        this.appendParameter("geocode", this.geocode, params);
        HttpParameter[] paramArray = new HttpParameter[params.size()];
        return params.toArray(paramArray);
    }

    private void appendParameter(String name, String value, List<HttpParameter> params) {
        if (null != value) {
            params.add(new HttpParameter(name, value));
        }
    }

    private void appendParameter(String name, long value, List<HttpParameter> params) {
        if (0L <= value) {
            params.add(new HttpParameter(name, String.valueOf(value)));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Query query1 = (Query)o;
        if (this.page != query1.page) {
            return false;
        }
        if (this.rpp != query1.rpp) {
            return false;
        }
        if (this.sinceId != query1.sinceId) {
            return false;
        }
        if (this.geocode != null ? !this.geocode.equals(query1.geocode) : query1.geocode != null) {
            return false;
        }
        if (this.lang != null ? !this.lang.equals(query1.lang) : query1.lang != null) {
            return false;
        }
        return !(this.query != null ? !this.query.equals(query1.query) : query1.query != null);
    }

    public int hashCode() {
        int result = this.query != null ? this.query.hashCode() : 0;
        result = 31 * result + (this.lang != null ? this.lang.hashCode() : 0);
        result = 31 * result + this.rpp;
        result = 31 * result + this.page;
        result = 31 * result + (int)(this.sinceId ^ this.sinceId >>> 32);
        result = 31 * result + (this.geocode != null ? this.geocode.hashCode() : 0);
        return result;
    }

    public String toString() {
        return new StringBuffer().append("Query{query='").append(this.query).append('\'').append(", lang='").append(this.lang).append('\'').append(", rpp=").append(this.rpp).append(", page=").append(this.page).append(", sinceId=").append(this.sinceId).append(", geocode='").append(this.geocode).append('\'').append('}').toString();
    }
}

