/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.File;
import java.io.Serializable;
import java.util.Date;
import twitter4j.Device;
import twitter4j.Dispatcher;
import twitter4j.GeoLocation;
import twitter4j.Paging;
import twitter4j.Query;
import twitter4j.RateLimitStatusListener;
import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.TwitterFactory;
import twitter4j.TwitterListener;
import twitter4j.TwitterMethod;
import twitter4j.TwitterOAuthSupportBase;
import twitter4j.api.AccountMethodsAsync;
import twitter4j.api.BlockMethodsAsync;
import twitter4j.api.DirectMessageMethodsAsync;
import twitter4j.api.FavoriteMethodsAsync;
import twitter4j.api.FriendshipMethodsAsync;
import twitter4j.api.HelpMethodsAsync;
import twitter4j.api.ListMembersMethodsAsync;
import twitter4j.api.ListMethodsAsync;
import twitter4j.api.ListSubscribersMethodsAsync;
import twitter4j.api.LocalTrendsMethodsAsync;
import twitter4j.api.NotificationMethodsAsync;
import twitter4j.api.SavedSearchesMethodsAsync;
import twitter4j.api.SearchMethodsAsync;
import twitter4j.api.SocialGraphMethodsAsync;
import twitter4j.api.SpamReportingMethodsAsync;
import twitter4j.api.StatusMethodsAsync;
import twitter4j.api.TimelineMethodsAsync;
import twitter4j.api.UserMethodsAsync;
import twitter4j.conf.Configuration;
import twitter4j.conf.ConfigurationContext;
import twitter4j.http.AccessToken;
import twitter4j.http.Authorization;
import twitter4j.http.HttpResponseEvent;
import twitter4j.http.RequestToken;

public class AsyncTwitter
extends TwitterOAuthSupportBase
implements Serializable,
SearchMethodsAsync,
TimelineMethodsAsync,
StatusMethodsAsync,
UserMethodsAsync,
ListMethodsAsync,
ListMembersMethodsAsync,
ListSubscribersMethodsAsync,
DirectMessageMethodsAsync,
FriendshipMethodsAsync,
SocialGraphMethodsAsync,
AccountMethodsAsync,
FavoriteMethodsAsync,
NotificationMethodsAsync,
BlockMethodsAsync,
SpamReportingMethodsAsync,
SavedSearchesMethodsAsync,
LocalTrendsMethodsAsync,
HelpMethodsAsync {
    private static final long serialVersionUID = -2008667933225051907L;
    private Twitter twitter;
    private TwitterListener listener;
    private static transient Dispatcher dispatcher;
    private boolean shutdown = false;

    public AsyncTwitter(String screenName, String password, TwitterListener listener) {
        super(ConfigurationContext.getInstance(), screenName, password);
        this.twitter = (Twitter)new TwitterFactory().getInstance(this.auth);
        this.listener = listener;
    }

    AsyncTwitter(Configuration conf, Authorization auth, TwitterListener listener) {
        super(conf, auth);
        this.twitter = (Twitter)new TwitterFactory(conf).getInstance(auth);
        this.listener = listener;
    }

    public void search(Query query) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.SEARCH, this.listener, new Object[]{query}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.searched(AsyncTwitter.this.twitter.search((Query)args[0]));
            }
        });
    }

    public void getTrends() {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.TRENDS, this.listener, null){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotTrends(AsyncTwitter.this.twitter.getTrends());
            }
        });
    }

    public void getCurrentTrends() {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.CURRENT_TRENDS, this.listener, null){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotCurrentTrends(AsyncTwitter.this.twitter.getCurrentTrends());
            }
        });
    }

    public void getCurrentTrends(boolean excludeHashTags) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.CURRENT_TRENDS, this.listener, new Object[]{new Boolean(excludeHashTags)}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotCurrentTrends(AsyncTwitter.this.twitter.getCurrentTrends((Boolean)args[0]));
            }
        });
    }

    public void getDailyTrends() {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.DAILY_TRENDS, this.listener, null){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotDailyTrends(AsyncTwitter.this.twitter.getDailyTrends());
            }
        });
    }

    public void getDailyTrends(Date date, boolean excludeHashTags) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.DAILY_TRENDS, this.listener, new Object[]{date, new Boolean(excludeHashTags)}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotDailyTrends(AsyncTwitter.this.twitter.getDailyTrends((Date)args[0], (Boolean)args[1]));
            }
        });
    }

    public void getWeeklyTrends() {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.WEEKLY_TRENDS, this.listener, null){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotWeeklyTrends(AsyncTwitter.this.twitter.getWeeklyTrends());
            }
        });
    }

    public void getWeeklyTrends(Date date, boolean excludeHashTags) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.WEEKLY_TRENDS, this.listener, new Object[]{date, new Boolean(excludeHashTags)}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotWeeklyTrends(AsyncTwitter.this.twitter.getWeeklyTrends((Date)args[0], (Boolean)args[1]));
            }
        });
    }

    public void getPublicTimeline() {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.PUBLIC_TIMELINE, this.listener, null){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotPublicTimeline(AsyncTwitter.this.twitter.getPublicTimeline());
            }
        });
    }

    public void getHomeTimeline() {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.HOME_TIMELINE, this.listener, null){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotHomeTimeline(AsyncTwitter.this.twitter.getHomeTimeline());
            }
        });
    }

    public void getHomeTimeline(Paging paging) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.HOME_TIMELINE, this.listener, new Object[]{paging}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotHomeTimeline(AsyncTwitter.this.twitter.getHomeTimeline((Paging)args[0]));
            }
        });
    }

    public void getFriendsTimeline() {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.FRIENDS_TIMELINE, this.listener, null){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotFriendsTimeline(AsyncTwitter.this.twitter.getFriendsTimeline());
            }
        });
    }

    public void getFriendsTimeline(Paging paging) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.FRIENDS_TIMELINE, this.listener, new Object[]{paging}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotFriendsTimeline(AsyncTwitter.this.twitter.getFriendsTimeline((Paging)args[0]));
            }
        });
    }

    public void getUserTimeline(String screenName, Paging paging) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.USER_TIMELINE, this.listener, new Object[]{screenName, paging}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotUserTimeline(AsyncTwitter.this.twitter.getUserTimeline((String)args[0], (Paging)args[1]));
            }
        });
    }

    public void getUserTimeline(int userId, Paging paging) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.USER_TIMELINE, this.listener, new Object[]{new Integer(userId), paging}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotUserTimeline(AsyncTwitter.this.twitter.getUserTimeline((Integer)args[0], (Paging)args[1]));
            }
        });
    }

    public void getUserTimeline(Paging paging) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.USER_TIMELINE, this.listener, new Object[]{paging}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotUserTimeline(AsyncTwitter.this.twitter.getUserTimeline((Paging)args[0]));
            }
        });
    }

    public void getUserTimeline(String screenName) {
        this.getUserTimeline(screenName, new Paging());
    }

    public void getUserTimeline(int userId) {
        this.getUserTimeline(userId, new Paging());
    }

    public void getUserTimeline() {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.USER_TIMELINE, this.listener, null){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotUserTimeline(AsyncTwitter.this.twitter.getUserTimeline());
            }
        });
    }

    public void getMentions() {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.MENTIONS, this.listener, null){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotMentions(AsyncTwitter.this.twitter.getMentions());
            }
        });
    }

    public void getMentions(Paging paging) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.MENTIONS, this.listener, new Object[]{paging}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotMentions(AsyncTwitter.this.twitter.getMentions((Paging)args[0]));
            }
        });
    }

    public void getRetweetedByMe() {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.RETWEETED_BY_ME, this.listener, null){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotRetweetedByMe(AsyncTwitter.this.twitter.getRetweetedByMe());
            }
        });
    }

    public void getRetweetedByMe(Paging paging) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.RETWEETED_BY_ME, this.listener, new Object[]{paging}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotRetweetedByMe(AsyncTwitter.this.twitter.getRetweetedByMe((Paging)args[0]));
            }
        });
    }

    public void getRetweetedToMe() {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.RETWEETED_TO_ME, this.listener, null){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotRetweetedToMe(AsyncTwitter.this.twitter.getRetweetedToMe());
            }
        });
    }

    public void getRetweetedToMe(Paging paging) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.RETWEETED_TO_ME, this.listener, new Object[]{paging}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotRetweetedToMe(AsyncTwitter.this.twitter.getRetweetedToMe((Paging)args[0]));
            }
        });
    }

    public void getRetweetsOfMe() {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.RETWEETS_OF_ME, this.listener, null){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotRetweetsOfMe(AsyncTwitter.this.twitter.getRetweetsOfMe());
            }
        });
    }

    public void getRetweetsOfMe(Paging paging) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.RETWEETS_OF_ME, this.listener, new Object[]{paging}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotRetweetsOfMe(AsyncTwitter.this.twitter.getRetweetsOfMe((Paging)args[0]));
            }
        });
    }

    public void showStatus(long id) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.SHOW_STATUS, this.listener, new Object[]{new Long(id)}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotShowStatus(AsyncTwitter.this.twitter.showStatus((Long)args[0]));
            }
        });
    }

    public void updateStatus(String status) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.UPDATE_STATUS, this.listener, new String[]{status}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.updatedStatus(AsyncTwitter.this.twitter.updateStatus((String)args[0]));
            }
        });
    }

    public void updateStatus(String status, GeoLocation location) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.UPDATE_STATUS, this.listener, new Object[]{status, location}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.updatedStatus(AsyncTwitter.this.twitter.updateStatus((String)args[0], (GeoLocation)args[1]));
            }
        });
    }

    public void updateStatus(String status, long inReplyToStatusId) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.UPDATE_STATUS, this.listener, new Object[]{status, new Long(inReplyToStatusId)}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.updatedStatus(AsyncTwitter.this.twitter.updateStatus((String)args[0], (Long)args[1]));
            }
        });
    }

    public void updateStatus(String status, long inReplyToStatusId, GeoLocation location) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.UPDATE_STATUS, this.listener, new Object[]{status, new Long(inReplyToStatusId), location}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.updatedStatus(AsyncTwitter.this.twitter.updateStatus((String)args[0], (Long)args[1], (GeoLocation)args[2]));
            }
        });
    }

    public void destroyStatus(long statusId) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.DESTROY_STATUS, this.listener, new Long[]{new Long(statusId)}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.destroyedStatus(AsyncTwitter.this.twitter.destroyStatus((Long)args[0]));
            }
        });
    }

    public void retweetStatus(long statusId) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.RETWEET_STATUS, this.listener, new Long[]{new Long(statusId)}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.retweetedStatus(AsyncTwitter.this.twitter.retweetStatus((Long)args[0]));
            }
        });
    }

    public void getRetweets(long statusId) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.RETWEETS, this.listener, new Long[]{new Long(statusId)}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotRetweets(AsyncTwitter.this.twitter.getRetweets((Long)args[0]));
            }
        });
    }

    public void showUser(String screenName) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.SHOW_USER, this.listener, new Object[]{screenName}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotUserDetail(AsyncTwitter.this.twitter.showUser((String)args[0]));
            }
        });
    }

    public void showUser(int userId) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.SHOW_USER, this.listener, new Object[]{new Integer(userId)}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotUserDetail(AsyncTwitter.this.twitter.showUser((Integer)args[0]));
            }
        });
    }

    public void searchUsers(String query, int page) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.SHOW_USER, this.listener, new Object[]{query, new Integer(page)}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.searchedUser(AsyncTwitter.this.twitter.searchUsers((String)args[0], (Integer)args[1]));
            }
        });
    }

    public void getFriendsStatuses() {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.FRIENDS_STATUSES, this.listener, null){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotFriendsStatuses(AsyncTwitter.this.twitter.getFriendsStatuses());
            }
        });
    }

    public void getFriendsStatuses(long cursor) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.FRIENDS_STATUSES, this.listener, new Object[]{new Long(cursor)}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotFriendsStatuses(AsyncTwitter.this.twitter.getFriendsStatuses((Long)args[0]));
            }
        });
    }

    public void getFriendsStatuses(String screenName) {
        this.getFriendsStatuses(screenName, -1L);
    }

    public void getFriendsStatuses(int userId) {
        this.getFriendsStatuses(userId, -1L);
    }

    public void getFriendsStatuses(String screenName, long cursor) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.FRIENDS_STATUSES, this.listener, new Object[]{screenName, new Long(cursor)}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotFriendsStatuses(AsyncTwitter.this.twitter.getFriendsStatuses((String)args[0], (long)((Long)args[1])));
            }
        });
    }

    public void getFriendsStatuses(int userId, long cursor) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.FRIENDS_STATUSES, this.listener, new Object[]{new Integer(userId), new Long(cursor)}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotFriendsStatuses(AsyncTwitter.this.twitter.getFriendsStatuses((Integer)args[0], (long)((Long)args[1])));
            }
        });
    }

    public void getFollowersStatuses() {
        this.getFollowersStatuses(-1L);
    }

    public void getFollowersStatuses(long cursor) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.FOLLOWERS_STATUSES, this.listener, new Object[]{new Long(cursor)}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotFollowersStatuses(AsyncTwitter.this.twitter.getFollowersStatuses((Long)args[0]));
            }
        });
    }

    public void getFollowersStatuses(String screenName) {
        this.getFollowersStatuses(screenName, -1L);
    }

    public void getFollowersStatuses(int userId) {
        this.getFollowersStatuses(userId, -1L);
    }

    public void getFollowersStatuses(String screenName, long cursor) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.FOLLOWERS_STATUSES, this.listener, new Object[]{screenName, new Long(cursor)}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotFollowersStatuses(AsyncTwitter.this.twitter.getFollowersStatuses((String)args[0], (long)((Long)args[1])));
            }
        });
    }

    public void getFollowersStatuses(int userId, long cursor) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.FOLLOWERS_STATUSES, this.listener, new Object[]{new Integer(userId), new Long(cursor)}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotFollowersStatuses(AsyncTwitter.this.twitter.getFollowersStatuses((Integer)args[0], (long)((Long)args[1])));
            }
        });
    }

    public void getDirectMessages() {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.DIRECT_MESSAGES, this.listener, null){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotDirectMessages(AsyncTwitter.this.twitter.getDirectMessages());
            }
        });
    }

    public void getDirectMessages(Paging paging) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.DIRECT_MESSAGES, this.listener, new Object[]{paging}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotDirectMessages(AsyncTwitter.this.twitter.getDirectMessages((Paging)args[0]));
            }
        });
    }

    public void getSentDirectMessages() {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.SENT_DIRECT_MESSAGES, this.listener, null){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotSentDirectMessages(AsyncTwitter.this.twitter.getSentDirectMessages());
            }
        });
    }

    public void getSentDirectMessages(Paging paging) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.SENT_DIRECT_MESSAGES, this.listener, new Object[]{paging}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotSentDirectMessages(AsyncTwitter.this.twitter.getSentDirectMessages((Paging)args[0]));
            }
        });
    }

    public void sendDirectMessage(String screenName, String text) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.SEND_DIRECT_MESSAGE, this.listener, new String[]{screenName, text}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.sentDirectMessage(AsyncTwitter.this.twitter.sendDirectMessage((String)args[0], (String)args[1]));
            }
        });
    }

    public void sendDirectMessage(int userId, String text) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.SEND_DIRECT_MESSAGE, this.listener, new Object[]{new Integer(userId), text}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.sentDirectMessage(AsyncTwitter.this.twitter.sendDirectMessage((Integer)args[0], (String)args[1]));
            }
        });
    }

    public void destroyDirectMessage(int id) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.DESTROY_DIRECT_MESSAGES, this.listener, new Object[]{new Integer(id)}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.destroyedDirectMessage(AsyncTwitter.this.twitter.destroyDirectMessage((Integer)args[0]));
            }
        });
    }

    public void createFriendship(String screenName) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.CREATE_FRIENDSHIP, this.listener, new String[]{screenName}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.createdFriendship(AsyncTwitter.this.twitter.createFriendship((String)args[0]));
            }
        });
    }

    public void createFriendship(int userId) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.CREATE_FRIENDSHIP, this.listener, new Integer[]{new Integer(userId)}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.createdFriendship(AsyncTwitter.this.twitter.createFriendship((Integer)args[0]));
            }
        });
    }

    public void createFriendship(String screenName, boolean follow) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.CREATE_FRIENDSHIP, this.listener, new Object[]{screenName, new Boolean(follow)}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.createdFriendship(AsyncTwitter.this.twitter.createFriendship((String)args[0], (boolean)((Boolean)args[1])));
            }
        });
    }

    public void createFriendship(int userId, boolean follow) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.CREATE_FRIENDSHIP, this.listener, new Object[]{new Integer(userId), new Boolean(follow)}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.createdFriendship(AsyncTwitter.this.twitter.createFriendship((Integer)args[0], (boolean)((Boolean)args[1])));
            }
        });
    }

    public void destroyFriendship(String screenName) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.DESTROY_FRIENDSHIP, this.listener, new String[]{screenName}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.destroyedFriendship(AsyncTwitter.this.twitter.destroyFriendship((String)args[0]));
            }
        });
    }

    public void destroyFriendship(int userId) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.DESTROY_FRIENDSHIP, this.listener, new Integer[]{new Integer(userId)}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.destroyedFriendship(AsyncTwitter.this.twitter.destroyFriendship((Integer)args[0]));
            }
        });
    }

    public void existsFriendship(String userA, String userB) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.EXISTS_FRIENDSHIP, this.listener, new String[]{userA, userB}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotExistsFriendship(AsyncTwitter.this.twitter.existsFriendship((String)args[0], (String)args[1]));
            }
        });
    }

    public void showFriendship(String sourceScreenName, String targetScreenName) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.SHOW_FRIENDSHIP, this.listener, new String[]{sourceScreenName, targetScreenName}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotShowFriendship(AsyncTwitter.this.twitter.showFriendship((String)args[0], (String)args[1]));
            }
        });
    }

    public void showFriendship(int sourceId, int targetId) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.SHOW_FRIENDSHIP, this.listener, new Integer[]{new Integer(sourceId), new Integer(targetId)}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotShowFriendship(AsyncTwitter.this.twitter.showFriendship((Integer)args[0], (Integer)args[1]));
            }
        });
    }

    public void getFriendsIDs() {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.FRIENDS_IDS, this.listener, null){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotFriendsIDs(AsyncTwitter.this.twitter.getFriendsIDs());
            }
        });
    }

    public void getFriendsIDs(long cursor) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.FRIENDS_IDS, this.listener, new Object[]{new Long(cursor)}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotFriendsIDs(AsyncTwitter.this.twitter.getFriendsIDs((Long)args[0]));
            }
        });
    }

    public void getFriendsIDs(int userId) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.FRIENDS_IDS, this.listener, new Integer[]{new Integer(userId)}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotFriendsIDs(AsyncTwitter.this.twitter.getFriendsIDs((Integer)args[0]));
            }
        });
    }

    public void getFriendsIDs(int userId, long cursor) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.FRIENDS_IDS, this.listener, new Object[]{new Integer(userId), new Long(cursor)}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotFriendsIDs(AsyncTwitter.this.twitter.getFriendsIDs((Integer)args[0], (long)((Long)args[1])));
            }
        });
    }

    public void getFriendsIDs(String screenName) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.FRIENDS_IDS, this.listener, new String[]{screenName}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotFriendsIDs(AsyncTwitter.this.twitter.getFriendsIDs((String)args[0]));
            }
        });
    }

    public void getFriendsIDs(String screenName, long cursor) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.FRIENDS_IDS, this.listener, new Object[]{screenName, new Long(cursor)}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotFriendsIDs(AsyncTwitter.this.twitter.getFriendsIDs((String)args[0], (long)((Long)args[1])));
            }
        });
    }

    public void getFollowersIDs() {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.FOLLOWERS_IDS, this.listener, null){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotFollowersIDs(AsyncTwitter.this.twitter.getFollowersIDs());
            }
        });
    }

    public void getFollowersIDs(long cursor) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.FOLLOWERS_IDS, this.listener, new Object[]{new Long(cursor)}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotFollowersIDs(AsyncTwitter.this.twitter.getFollowersIDs((Long)args[0]));
            }
        });
    }

    public void getFollowersIDs(int userId) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.FOLLOWERS_IDS, this.listener, new Integer[]{new Integer(userId)}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotFollowersIDs(AsyncTwitter.this.twitter.getFollowersIDs((Integer)args[0]));
            }
        });
    }

    public void getFollowersIDs(int userId, long cursor) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.FOLLOWERS_IDS, this.listener, new Object[]{new Integer(userId), new Long(cursor)}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotFollowersIDs(AsyncTwitter.this.twitter.getFollowersIDs((Integer)args[0], (long)((Long)args[1])));
            }
        });
    }

    public void getFollowersIDs(String screenName) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.FOLLOWERS_IDS, this.listener, new String[]{screenName}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotFollowersIDs(AsyncTwitter.this.twitter.getFollowersIDs((String)args[0]));
            }
        });
    }

    public void getFollowersIDs(String screenName, long cursor) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.FOLLOWERS_IDS, this.listener, new Object[]{screenName, new Long(cursor)}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotFollowersIDs(AsyncTwitter.this.twitter.getFollowersIDs((String)args[0], (long)((Long)args[1])));
            }
        });
    }

    public void updateProfile(String name, String email, String url, String location, String description) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.UPDATE_PROFILE, this.listener, new String[]{name, email, url, location, description}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.updatedProfile(AsyncTwitter.this.twitter.updateProfile((String)args[0], (String)args[1], (String)args[2], (String)args[3], (String)args[4]));
            }
        });
    }

    public void getRateLimitStatus() {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.RATE_LIMIT_STATUS, this.listener, new Object[0]){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotRateLimitStatus(AsyncTwitter.this.twitter.getRateLimitStatus());
            }
        });
    }

    public void updateDeliveryDevice(Device device) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.UPDATE_DELIVERY_DEVICE, this.listener, new Object[]{device}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.updatedDeliveryDevice(AsyncTwitter.this.twitter.updateDeliveryDevice((Device)args[0]));
            }
        });
    }

    public void updateProfileColors(String profileBackgroundColor, String profileTextColor, String profileLinkColor, String profileSidebarFillColor, String profileSidebarBorderColor) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.UPDATE_PROFILE_COLORS, this.listener, new Object[]{profileBackgroundColor, profileTextColor, profileLinkColor, profileSidebarFillColor, profileSidebarBorderColor}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.updatedProfileColors(AsyncTwitter.this.twitter.updateProfileColors((String)args[0], (String)args[1], (String)args[2], (String)args[3], (String)args[4]));
            }
        });
    }

    public void updateProfileImage(File image) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.UPDATE_PROFILE_IMAGE, this.listener, new Object[]{image}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.updatedProfileImage(AsyncTwitter.this.twitter.updateProfileImage((File)args[0]));
            }
        });
    }

    public void updateProfileBackgroundImage(File image, boolean tile) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.UPDATE_PROFILE_BACKGROUND_IMAGE, this.listener, new Object[]{image, new Boolean(tile)}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.updatedProfileBackgroundImage(AsyncTwitter.this.twitter.updateProfileBackgroundImage((File)args[0], (Boolean)args[1]));
            }
        });
    }

    public void getFavorites() {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.FAVORITES, this.listener, null){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotFavorites(AsyncTwitter.this.twitter.getFavorites());
            }
        });
    }

    public void getFavorites(int page) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.FAVORITES, this.listener, new Object[]{new Integer(page)}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotFavorites(AsyncTwitter.this.twitter.getFavorites((Integer)args[0]));
            }
        });
    }

    public void getFavorites(String id) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.FAVORITES, this.listener, new Object[]{id}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotFavorites(AsyncTwitter.this.twitter.getFavorites((String)args[0]));
            }
        });
    }

    public void getFavorites(String id, int page) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.FAVORITES, this.listener, new Object[]{id, new Integer(page)}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotFavorites(AsyncTwitter.this.twitter.getFavorites((String)args[0], (Integer)args[1]));
            }
        });
    }

    public void createFavorite(long id) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.CREATE_FAVORITE, this.listener, new Object[]{new Long(id)}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.createdFavorite(AsyncTwitter.this.twitter.createFavorite((Long)args[0]));
            }
        });
    }

    public void destroyFavorite(long id) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.DESTROY_FAVORITE, this.listener, new Object[]{new Long(id)}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.destroyedFavorite(AsyncTwitter.this.twitter.destroyFavorite((Long)args[0]));
            }
        });
    }

    public void enableNotification(String screenName) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.ENABLE_NOTIFICATION, this.listener, new String[]{screenName}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.enabledNotification(AsyncTwitter.this.twitter.enableNotification((String)args[0]));
            }
        });
    }

    public void enableNotification(int userId) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.ENABLE_NOTIFICATION, this.listener, new Integer[]{new Integer(userId)}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.enabledNotification(AsyncTwitter.this.twitter.enableNotification((Integer)args[0]));
            }
        });
    }

    public void disableNotification(String screenName) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.DISABLE_NOTIFICATION, this.listener, new String[]{screenName}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.disabledNotification(AsyncTwitter.this.twitter.disableNotification((String)args[0]));
            }
        });
    }

    public void disableNotification(int userId) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.DISABLE_NOTIFICATION, this.listener, new Integer[]{new Integer(userId)}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.disabledNotification(AsyncTwitter.this.twitter.disableNotification((Integer)args[0]));
            }
        });
    }

    public void createBlock(String screenName) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.CREATE_BLOCK, this.listener, new String[]{screenName}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.createdBlock(AsyncTwitter.this.twitter.createBlock((String)args[0]));
            }
        });
    }

    public void createBlockAsync(int userId) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.CREATE_BLOCK, this.listener, new Integer[]{new Integer(userId)}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.createdBlock(AsyncTwitter.this.twitter.createBlock((Integer)args[0]));
            }
        });
    }

    public void destroyBlock(String screenName) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.DESTROY_BLOCK, this.listener, new String[]{screenName}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.destroyedBlock(AsyncTwitter.this.twitter.destroyBlock((String)args[0]));
            }
        });
    }

    public void destroyBlock(int userId) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.DESTROY_BLOCK, this.listener, new Integer[]{new Integer(userId)}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.destroyedBlock(AsyncTwitter.this.twitter.destroyBlock((Integer)args[0]));
            }
        });
    }

    public void existsBlock(String screenName) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.EXISTS_BLOCK, this.listener, new String[]{screenName}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotExistsBlock(AsyncTwitter.this.twitter.existsBlock((String)args[0]));
            }
        });
    }

    public void existsBlock(int userId) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.EXISTS_BLOCK, this.listener, new Integer[]{new Integer(userId)}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotExistsBlock(AsyncTwitter.this.twitter.existsBlock((Integer)args[0]));
            }
        });
    }

    public void getBlockingUsers() {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.BLOCKING_USERS, this.listener, null){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotBlockingUsers(AsyncTwitter.this.twitter.getBlockingUsers());
            }
        });
    }

    public void getBlockingUsers(int page) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.BLOCKING_USERS, this.listener, new Integer[]{new Integer(page)}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotBlockingUsers(AsyncTwitter.this.twitter.getBlockingUsers((Integer)args[0]));
            }
        });
    }

    public void getBlockingUsersIDs() {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.BLOCKING_USERS_IDS, this.listener, null){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotBlockingUsersIDs(AsyncTwitter.this.twitter.getBlockingUsersIDs());
            }
        });
    }

    public void reportSpam(int userId) throws TwitterException {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.REPORT_SPAM, this.listener, new Integer(userId)){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.reportedSpam(AsyncTwitter.this.twitter.reportSpam((Integer)args[0]));
            }
        });
    }

    public void reportSpam(String screenName) throws TwitterException {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.REPORT_SPAM, this.listener, screenName){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.reportedSpam(AsyncTwitter.this.twitter.reportSpam((String)args[0]));
            }
        });
    }

    public void test() {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.TEST, this.listener, new Object[0]){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.tested(AsyncTwitter.this.twitter.test());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Class clazz = AsyncTwitter.class;
        synchronized (clazz) {
            if (this.shutdown) {
                throw new IllegalStateException("Already shut down");
            }
            this.getDispatcher().shutdown();
            dispatcher = null;
            this.shutdown = true;
        }
    }

    private Dispatcher getDispatcher() {
        if (this.shutdown) {
            throw new IllegalStateException("Already shut down");
        }
        if (null == dispatcher) {
            dispatcher = new Dispatcher(this.conf, "Twitter4J Async Dispatcher", ConfigurationContext.getInstance().getAsyncNumThreads());
        }
        return dispatcher;
    }

    public void setOAuthConsumer(String consumerKey, String consumerSecret) {
        this.twitter.setOAuthConsumer(consumerKey, consumerSecret);
    }

    public RequestToken getOAuthRequestToken() throws TwitterException {
        return this.twitter.getOAuthRequestToken();
    }

    public RequestToken getOAuthRequestToken(String callbackUrl) throws TwitterException {
        return this.twitter.getOAuthRequestToken(callbackUrl);
    }

    public AccessToken getOAuthAccessToken() throws TwitterException {
        return this.twitter.getOAuthAccessToken();
    }

    public AccessToken getOAuthAccessToken(String oauthVerifier) throws TwitterException {
        return this.twitter.getOAuthAccessToken(oauthVerifier);
    }

    public AccessToken getOAuthAccessToken(RequestToken requestToken) throws TwitterException {
        return this.twitter.getOAuthAccessToken(requestToken);
    }

    public AccessToken getOAuthAccessToken(RequestToken requestToken, String oauthVerifier) throws TwitterException {
        return this.twitter.getOAuthAccessToken(requestToken, oauthVerifier);
    }

    public void setOAuthAccessToken(AccessToken accessToken) {
        this.twitter.setOAuthAccessToken(accessToken);
    }

    public AccessToken getOAuthAccessToken(String token, String tokenSecret) throws TwitterException {
        return this.twitter.getOAuthAccessToken(token, tokenSecret);
    }

    public AccessToken getOAuthAccessToken(String token, String tokenSecret, String pin) throws TwitterException {
        return this.twitter.getOAuthAccessToken(token, tokenSecret, pin);
    }

    public void setOAuthAccessToken(String token, String tokenSecret) {
        this.twitter.setOAuthAccessToken(token, tokenSecret);
    }

    public /* synthetic */ void httpResponseReceived(HttpResponseEvent x0) {
        super.httpResponseReceived(x0);
    }

    public /* synthetic */ int hashCode() {
        return super.hashCode();
    }

    public /* synthetic */ boolean equals(Object x0) {
        return super.equals(x0);
    }

    public /* synthetic */ void setRateLimitStatusListener(RateLimitStatusListener x0) {
        super.setRateLimitStatusListener(x0);
    }

    public /* synthetic */ boolean isOAuthEnabled() {
        return super.isOAuthEnabled();
    }

    public /* synthetic */ String toString() {
        return super.toString();
    }

    public /* synthetic */ Authorization getAuthorization() {
        return super.getAuthorization();
    }

    public /* synthetic */ boolean isBasicAuthEnabled() {
        return super.isBasicAuthEnabled();
    }

    abstract class AsyncTask
    implements Runnable {
        TwitterListener listener;
        Object[] args;
        TwitterMethod method;

        AsyncTask(TwitterMethod method, TwitterListener listener, Object[] args) {
            this.method = method;
            this.listener = listener;
            this.args = args;
        }

        AsyncTask(TwitterMethod method, TwitterListener listener, Object arg) {
            this.method = method;
            this.listener = listener;
            this.args = new Object[]{arg};
        }

        abstract void invoke(TwitterListener var1, Object[] var2) throws TwitterException;

        public void run() {
            block2: {
                try {
                    this.invoke(this.listener, this.args);
                }
                catch (TwitterException te) {
                    if (null == this.listener) break block2;
                    this.listener.onException(te, this.method);
                }
            }
        }
    }
}

